% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometry.R
\name{vertexComponents}
\alias{vertexComponents}
\title{Return the connected components of vertices}
\usage{
vertexComponents(df, colName = "component")
}
\arguments{
\item{df}{A data frame with two categorical columns representing graph edges
and a connected components column.}

\item{colName}{Name of the connected components column.}
}
\value{
A factor vector representing the connected component of each
vertex.
}
\description{
This function returns the connected components of vertices from a graph
data frame in which edges have been assigned connected components.
}
\examples{
df <- data.frame(gene1 = c('A', 'B', 'C', 'A'),
gene2 = c('B', 'D', 'F', 'G'),
component = c(1, 1, 2, 1))
vertexComponents(df)

}
