% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_city_map.R
\name{get_city_map}
\alias{get_city_map}
\title{Get city administrative regions}
\source{
Metropolitan area in districts: \url{https://hri.fi/data/en_GB/dataset/seutukartta}
}
\usage{
get_city_map(city = NULL, level = NULL, ...)
}
\arguments{
\item{city}{The desired city. Valid options: \emph{Helsinki}, \emph{Espoo}, \emph{Vantaa},
\emph{Kauniainen}}

\item{level}{The desired administrative level. Valid options: \emph{suurpiiri},
\emph{tilastoalue}, \emph{pienalue} and \emph{aanestysalue}}

\item{...}{For passing parameters to embedded functions, for example
\emph{timeout.s} (timeout in seconds) in the case of \strong{gracefully_fail()}
internal function}
}
\value{
sf object
}
\description{
Sf object of city districts in the Helsinki Capital Region.
}
\details{
See \code{\link[=get_feature_list]{get_feature_list()}} for a list of all available features
}
\examples{
\dontrun{
map <- get_city_map(city = "helsinki", level = "suuralue")
}

}
\author{
Pyry Kantanen \href{mailto:pyry.kantanen@gmail.com}{pyry.kantanen@gmail.com}
}
