% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heaping_indices.R
\name{bachi}
\alias{bachi}
\title{Bachi's Index of Age Heaping}
\usage{
bachi(x, ageMin = 23, ageMax = 77, weight = NULL)
}
\arguments{
\item{x}{numeric vector of individual ages.}

\item{ageMin}{minimum age to include (default 23).}

\item{ageMax}{maximum age to include (default 77, adjusted to fit decades).}

\item{weight}{optional numeric vector of sampling weights.}
}
\value{
A single numeric value representing Bachi's index.
}
\description{
Bachi's index involves applying the Whipple method repeatedly to determine
the extent of preference for each terminal digit (0-9). It equals the sum
of positive deviations from 10 percent.
}
\details{
Calculate Bachi's index to measure digit preference in age data.


The theoretical range is 0 to 90:
\itemize{
  \item 0: no digit preference (each digit represents 10% of population)
  \item 90: maximum heaping (all ages end in same digit)
}

For populations with no age heaping, each digit should appear in
approximately 10% of reported ages.
}
\examples{
# No heaping
set.seed(42)
age_uniform <- sample(23:77, 10000, replace = TRUE)
bachi(age_uniform)  # Should be close to 0

# Strong heaping on 0 and 5
age_heaped <- sample(seq(25, 75, by = 5), 5000, replace = TRUE)
bachi(age_heaped)  # Should be high

}
\references{
Bachi, R. (1951). The tendency to round off age returns: measurement and
correction. \emph{Bulletin of the International Statistical Institute},
\strong{33}(4), 195-222.
}
\seealso{
\code{\link{myers}} for Myers' index,
  \code{\link{whipple}} for Whipple's index.

Other heaping indices: 
\code{\link{coale_li}()},
\code{\link{heaping_indices}()},
\code{\link{jdanov}()},
\code{\link{kannisto}()},
\code{\link{myers}()},
\code{\link{noumbissi}()},
\code{\link{spoorenberg}()},
\code{\link{whipple}()}
}
\author{
Matthias Templ
}
\concept{heaping indices}
