% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plt-ts.R
\name{ts_plt}
\alias{ts_plt}
\title{Time Series Plot}
\usage{
ts_plt(
  .data,
  .date_col,
  .value_col,
  .color_col = NULL,
  .facet_col = NULL,
  .facet_ncol = NULL,
  .interactive = FALSE
)
}
\arguments{
\item{.data}{The data to pass to the function, must be a tibble/data.frame.}

\item{.date_col}{The column holding the date.}

\item{.value_col}{The column holding the value.}

\item{.color_col}{The column holding the variable for color.}

\item{.facet_col}{The column holding the variable for faceting.}

\item{.facet_ncol}{How many columns do you want.}

\item{.interactive}{Return a \code{plotly} plot if set to TRUE and a static \code{ggplot2}
plot if set to FALSE. The default is FALSE.}
}
\value{
A \code{plotly} plot or a \code{ggplot2} static plot
}
\description{
This is a warpper function to the \code{\link[timetk:plot_time_series]{timetk::plot_time_series()}} function with
a limited functionality parameter set. To see the full reference please visit
the \code{timetk} package site.
}
\details{
This function takes only a few of the arguments in the function and
presets others while choosing the defaults on others. The smoother functionality
is turned off.
}
\examples{
suppressPackageStartupMessages(library(dplyr))
library(timetk)
library(healthyR.data)

healthyR.data::healthyR_data \%>\%
  filter(ip_op_flag == "I") \%>\%
  select(visit_end_date_time, service_line) \%>\%
  filter_by_time(
    .date_var = visit_end_date_time
    , .start_date = "2020"
    ) \%>\%
  group_by(service_line) \%>\%
  summarize_by_time(
    .date_var = visit_end_date_time
    , .by = "month"
    , visits = n()
  ) \%>\%
 ungroup() \%>\%
 ts_plt(
   .date_col = visit_end_date_time
   , .value_col = visits
   , .color_col = service_line
 )

}
\seealso{
\url{https://business-science.github.io/timetk/reference/plot_time_series.html}

Other Plotting Functions: 
\code{\link{diverging_bar_plt}()},
\code{\link{diverging_lollipop_plt}()},
\code{\link{gartner_magic_chart_plt}()},
\code{\link{los_ra_index_plt}()},
\code{\link{ts_alos_plt}()},
\code{\link{ts_median_excess_plt}()},
\code{\link{ts_readmit_rate_plt}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Plotting Functions}
