% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_risk.R
\name{get_risk}
\alias{get_risk}
\title{Get the relative risk of an exposure level}
\usage{
get_risk(
  erf_shape = NULL,
  rr = NULL,
  rr_increment = NULL,
  erf_eq = NULL,
  cutoff = 0,
  exp
)
}
\arguments{
\item{erf_shape}{\code{String value} specifying the \strong{exposure-response function shape} to be assumed. Options (no default): \code{"linear"}, \code{log_linear}", \code{"linear_log"}, \code{"log_log"}. \emph{Only applicable in RR pathways; not required if \code{erf_eq_...} argument(s) already specified.}}

\item{rr}{\code{Numeric value} or \code{numeric vector} specifying the \strong{relative risk} estimate(s) and (optionally) the corresponding lower and upper 95\% confidence interval bounds. Not required if the \code{erf_eq} argument is already specified.}

\item{rr_increment}{\code{Numeric value} specifying the \strong{exposure increment} for which the provided relative risk is valid. See Details for more info. \emph{Only applicable in RR pathways; not required if \code{erf_eq_...} argument(s) already specified.}}

\item{erf_eq}{\code{String} or \code{function} specifying the \strong{exposure-response function} and (optionally) the corresponding lower and upper 95\% confidence interval functions. See Details and Examples sections below.}

\item{cutoff}{\code{Numeric value} specifying the \strong{exposure cut-off value} (i.e. the exposure level below which no health effects occur) and (optionally) the corresponding lower and upper 95\% confidence interval bounds.}

\item{exp}{\code{Numeric value} or \code{numeric vector} specifying the \strong{exposure level(s)} to the environmental stressor (e.g. annual population-weighted mean) and (optionally) the corresponding lower and upper bound of the 95\% confidence interval.}
}
\value{
This function returns the \code{numeric} risk value(s) at the specified exposure level(s), referred to as \emph{rr_at_exp} in the relative risk equations above.
}
\description{
This function re-scales the relative risk from the increment value in the epidemiological study
(e.g. for PM2.5 10 or 5 ug/m3) to the actual population exposure
}
\details{
\strong{Function arguments}
\code{erf_eq}
If the function is provided as \code{string},
it can only contain the variable c (exposure), e.g. "3+c+c^2".
If the function is provided as a \code{function},
the object must be of the class function.
If only the values of the x-axis (exposure) and y axis (relative risk)
of the dots in the exposure-response function are available,
a cubic spline natural interpolation can be assumed to get the function using,
e.g., \code{stats::splinefun(x, y, method="natural")}

\strong{Methodology}

This function is called internally inside other \code{healthiar} functions, e.g. \code{attribute_health()}.
The function calculates the relative risk at the exposure level based on the
relative risk available in the epidemiological literature and the assumed shape
of the exposure-response function
\insertCite{Pozzer2023_gh,Lehtomaki_2025_eh}{healthiar}.

Detailed information about the methodology
(including corresponding equations and literature)
is available in the package vignette.
More specifically, see chapters:
\itemize{
 \item \href{https://swisstph.github.io/healthiar/articles/intro_to_healthiar.html#relative-risk}{relative risk}}
}
\examples{

# Goal: scale relative risk to observed exposure level
get_risk(
  rr = 1.05,
  rr_increment = 10,
  erf_shape = "linear",
  exp = 10,
  cutoff = 5
)

# Goal: determine the absolute risk for high annoyance at specific noise exposure levels
get_risk(
  erf_eq = "78.9270-3.1162*c+0.0342*c^2",
  exp = c(57.5, 62.5, 67.5, 72.5, 77.5)
)

# Goal: attribute COPD cases to air pollution exposure
# by applying a user-defined exposure response function,
# e.g. MR-BRT curves from Global Burden of Disease study.
get_risk(
  erf_eq = splinefun(
    x = c(0, 5, 10, 15, 20, 25, 30, 50, 70, 90, 110),
    y = c(1.00, 1.04, 1.08, 1.12, 1.16, 1.20, 1.23, 1.35, 1.45, 1.53, 1.60),
    method = "natural"),
  exp = c(8, 9, 10)
)


}
\references{
\insertAllCited{}
}
\seealso{
\itemize{
  \item Alternative: \code{\link{attribute_health}}, \code{\link{attribute_lifetable}}
}
}
\author{
Alberto Castro & Axel Luyten
}
