% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pof.R
\name{pof_registers}
\alias{pof_registers}
\title{List POF registers}
\usage{
pof_registers(year = "2017-2018", health_only = FALSE)
}
\arguments{
\item{year}{Character. POF edition (e.g., "2017-2018").
Default is "2017-2018".}

\item{health_only}{Logical. If TRUE, returns only health-related registers.
Default is FALSE.}
}
\value{
A tibble with register names and descriptions.
}
\description{
Returns information about the data registers available in the POF.
}
\examples{
pof_registers()
pof_registers("2017-2018", health_only = TRUE)
}
\seealso{
Other pof: 
\code{\link{pof_cache_status}()},
\code{\link{pof_clear_cache}()},
\code{\link{pof_data}()},
\code{\link{pof_dictionary}()},
\code{\link{pof_info}()},
\code{\link{pof_variables}()},
\code{\link{pof_years}()}
}
\concept{pof}
