% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pof.R
\name{pof_data}
\alias{pof_data}
\title{Download and import POF microdata}
\usage{
pof_data(
  year = "2017-2018",
  register = "morador",
  vars = NULL,
  cache_dir = NULL,
  as_survey = FALSE,
  refresh = FALSE,
  lazy = FALSE,
  backend = c("arrow", "duckdb")
)
}
\arguments{
\item{year}{Character. POF edition (e.g., "2017-2018"). Default is "2017-2018".}

\item{register}{Character. Which register to download.
Use \code{pof_registers()} to see available options.
Default is "morador".}

\item{vars}{Character vector. Optional: specific variables to select.
If NULL, returns all variables from the register. Default is NULL.}

\item{cache_dir}{Character. Directory for caching downloaded files.
Default uses \code{tools::R_user_dir("healthbR", "cache")}.}

\item{as_survey}{Logical. If TRUE, returns survey design object.
Requires srvyr package. Default is FALSE.}

\item{refresh}{Logical. If TRUE, re-download even if file exists in cache.
Default is FALSE.}

\item{lazy}{Logical. If TRUE, returns a lazy query object instead of a
tibble. Requires the \pkg{arrow} package. The lazy object supports
dplyr verbs (filter, select, mutate, etc.) which are pushed down
to the query engine before collecting into memory. Call
\code{dplyr::collect()} to materialize the result. Default: FALSE.}

\item{backend}{Character. Backend for lazy evaluation: \code{"arrow"}
(default) or \code{"duckdb"}. Only used when \code{lazy = TRUE}.
DuckDB backend requires the \pkg{duckdb} package.}
}
\value{
A tibble with microdata, or tbl_svy if as_survey = TRUE.
}
\description{
Downloads POF microdata from IBGE FTP and returns as a tibble.
Data is cached locally to avoid repeated downloads.
}
\details{
The POF (Pesquisa de Orcamentos Familiares) is a household survey conducted
by IBGE that investigates household budgets, living conditions, and
nutritional profiles of the Brazilian population.
\subsection{Health-related data}{

The POF contains several health-related modules:
\itemize{
\item \strong{EBIA} (Food Security Scale): Available in 2017-2018, variable V6199
in the domicilio register
\item \strong{Food Consumption}: Detailed food consumption data in the
consumo_alimentar register (2008-2009, 2017-2018)
\item \strong{Health Expenses}: Expenses with medications, health insurance,
consultations in the despesa_individual register
\item \strong{Anthropometry}: Weight, height, BMI in morador register (2008-2009 only)
}
}

\subsection{Survey design}{

For proper statistical analysis with complex survey design, use
\code{as_survey = TRUE} which creates a survey design object with:
\itemize{
\item Weight variable: PESO_FINAL
\item Stratum variable: ESTRATO_POF
\item PSU variable: COD_UPA
}
}
}
\section{Data source}{

Data is downloaded from the IBGE FTP server:
\verb{https://ftp.ibge.gov.br/Orcamentos_Familiares/}
}

\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
# basic usage - download morador register
morador <- pof_data("2017-2018", "morador", cache_dir = tempdir())

# download domicilio register (includes EBIA)
domicilio <- pof_data("2017-2018", "domicilio", cache_dir = tempdir())

# select specific variables
df <- pof_data(
  "2017-2018", "morador",
  vars = c("COD_UPA", "ESTRATO_POF", "PESO_FINAL", "V0403"),
  cache_dir = tempdir()
)

# with survey design (requires srvyr package)
morador_svy <- pof_data("2017-2018", "morador", as_survey = TRUE,
                         cache_dir = tempdir())
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{pof_years}}, \code{\link{pof_info}},
\code{\link{pof_registers}}, \code{\link{pof_variables}}

Other pof: 
\code{\link{pof_cache_status}()},
\code{\link{pof_clear_cache}()},
\code{\link{pof_dictionary}()},
\code{\link{pof_info}()},
\code{\link{pof_registers}()},
\code{\link{pof_variables}()},
\code{\link{pof_years}()}
}
\concept{pof}
