% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/20241206_simulation_function_edit.R
\name{simulation.hetero}
\alias{simulation.hetero}
\title{Monte Carlo simulation for heterogeneity of threshold effects under known threshold location}
\usage{
simulation.hetero(
  N,
  TL,
  p,
  M,
  epsilon = c("iid", "factor"),
  running = c("iid", "factor"),
  hetero = c(0, 1)
)
}
\arguments{
\item{N}{cross-sectional dimension}

\item{TL}{time series length}

\item{p}{fraction of non-zero coefficients}

\item{M}{number of Monte Carlo runs}

\item{epsilon}{specification of error term. If \code{"iid"} is selected the error term is iid standard normal.
If \code{"factor"} is selected, the error term follows a factor model with strong cross-sectional and weak
temporal dependence.}

\item{running}{specification of running variable. If \code{"iid"} is selected the running variable is iid uniformly
distributed. If \code{"factor"} is selected, the running variable follows a factor model with strong cross-sectional and weak
temporal dependence.}

\item{hetero}{if \code{hetero=1} the error term is heteroskedastic, if \code{hetero=0} the error term is homoskedastic.}
}
\value{
A list containing the value of the test statistic for each Monte Carlo run and the
empirical rejection rate for a 10\%, 5\% and 1\% confidence level.
}
\description{
Monte Carlo simulation to study the size and power properties of the uniform test
for heterogeneity of threshold effects under known threshold locations. Provides the Monte Carlo
distribution of the test statistic and empirical rejection probabilities at 10\%, 5\% and 1\% level.
}
\examples{
result_hetero = simulation.hetero(10, 200, 0, 10, epsilon = "iid",
                running = "iid", hetero = 0)
}
