% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdf5-functions.R
\name{h5Backup}
\alias{h5Backup}
\title{Back up contents from one HDF5 file to another}
\usage{
h5Backup(
  from.file,
  to.file = NULL,
  exclude = NULL,
  overwrite = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{from.file}{The source HDF5 file.}

\item{to.file}{The target HDF5 file. Cannot be the same file as 
\code{from.file}. If \code{NULL}, will generate an R temp file.}

\item{exclude}{Names of HDF5 links not to be backed up.}

\item{overwrite}{When the \code{to.file} already exists, whether or not to 
overwrite it.}

\item{verbose}{Print progress.}

\item{...}{Arguments passed to \code{H5File$obj_copy_from()}}
}
\value{
Path of the \code{to.file}
}
\description{
Function to back up HDF5 file, with optionally excluding specific links.
}
\details{
When any HDF5 link is to be excluded, it will copy the rest of links from
\code{from.file} using \code{\link{h5Copy}}. Otherwise, it will simply copy 
the \code{from.file} to the \code{to.file} via \code{\link{file.copy}}
}
\examples{
file <- system.file("extdata", "pbmc_small.h5ad", package = "hdf5r.Extra")
to.file <- tempfile(fileext = ".h5")

h5Backup(file, to.file, exclude = "X")

x <- h5Read(file)
x2 <- h5Read(to.file)
x$X <- NULL # Remove 'X'
identical(x, x2) # Now these two should be identical

}
