% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdcate_main_operators.R
\name{HDCATE.unset_first_stage}
\alias{HDCATE.unset_first_stage}
\title{Clear the user-defined first-stage estimating methods}
\usage{
HDCATE.unset_first_stage(model)
}
\arguments{
\item{model}{an object created via \link{HDCATE}}
}
\value{
None.
}
\description{
Inverse operation of \link{HDCATE.set_first_stage}
}
\examples{
# get simulation data
n_obs <- 500  # Num of observations
n_var <- 100  # Num of observed variables
n_rel_var <- 4  # Num of relevant variables
data <- HDCATE.get_sim_data(n_obs, n_var, n_rel_var)
# conditional expectation model is misspecified
x_formula <- paste(paste0('X', c(2:n_var)), collapse ='+')
# propensity score model is misspecified
# x_formula <- paste(paste0('X', c(1:(n_var-1))), collapse ='+')

# create a new HDCATE model
model <- HDCATE(data=data, y_name='Y', d_name='D', x_formula=x_formula)

# ... manually set user-defined first-stage estimating methods via `HDCATE.set_first_stage`

# Clear those user-defined methods and use the built-in method
HDCATE.unset_first_stage(model)
}
