% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdcate_main_operators.R
\name{HDCATE}
\alias{HDCATE}
\title{High-Dimensional Conditional Average Treatment Effects (HDCATE) Estimator}
\usage{
HDCATE(data, y_name, d_name, x_formula)
}
\arguments{
\item{data}{data frame of the observed data}

\item{y_name}{variable name of the observed outcomes}

\item{d_name}{variable name of the treatment indicators}

\item{x_formula}{formula of the covariates}
}
\value{
An initialized \code{HDCATE} model (object), ready for estimation.
}
\description{
Use a two-step procedure to estimate the conditional average treatment effects (CATE) with potentially high-dimensional covariate(s).
Run \code{browseVignettes('hdcate')} to browse the user manual of this package.
}
\examples{
# get simulation data
n_obs <- 500  # Num of observations
n_var <- 100  # Num of observed variables
n_rel_var <- 4  # Num of relevant variables
data <- HDCATE.get_sim_data(n_obs, n_var, n_rel_var)
# conditional expectation model is misspecified
x_formula <- paste(paste0('X', c(2:n_var)), collapse ='+')
# for example, and alternatively, the propensity score model is misspecified
# x_formula <- paste(paste0('X', c(1:(n_var-1))), collapse ='+')

# Example 1: full-sample estimator
# create a new HDCATE model
model <- HDCATE(data=data, y_name='Y', d_name='D', x_formula=x_formula)

# estimate HDCATE function, inference, and plot
HDCATE.set_condition_var(model, 'X2', min=-1, max=1, step=0.01)
\donttest{
HDCATE.fit(model)
HDCATE.inference(model)
HDCATE.plot(model)
}

# Example 2: cross-fitting estimator
# change above estimator to cross-fitting mode, 5 folds, for example.
HDCATE.use_cross_fitting(model, k_fold=5)

# estimate HDCATE function, inference, and plot
HDCATE.set_condition_var(model, 'X2', min=-1, max=1, step=0.01)
\donttest{
HDCATE.fit(model)
HDCATE.inference(model)
HDCATE.plot(model)
}
}
