% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/haplotyper.R
\name{haplotyper}
\alias{haplotyper}
\title{haplotyper function identifies haplotypes within QTL.}
\usage{
haplotyper(x, Print = FALSE)
}
\arguments{
\item{x}{a data.frame that should be loaded with read.table function.
Each row represents the individuals while each column represents the markers.
The first column contains the names of the genotypes.}

\item{Print}{option for print the haplotyper result.
The default is FALSE}
}
\value{
a matrix with the haplotypes
}
\description{
This function groups together all individuals of a population
with the same haplotype.
}
\details{
Each group contains individual with the same allele in each SNP,
whether or not missing data.
}
\examples{
\dontrun{
data(rice_qtl)
haplotyper(rice_qtl)
}
}
\author{
Sebastian Simondi, Victoria Bonnecarrere, Lucia Gutierrez,
Gaston Quero
}
\seealso{
read.table function
}

