% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hahmmr.R
\name{run_joint_hmm_s7}
\alias{run_joint_hmm_s7}
\title{Run 7-state joint HMM on a pseudobulk profile}
\usage{
run_joint_hmm_s7(
  pAD,
  DP,
  R,
  p_s,
  Y_obs,
  lambda_ref,
  d_total,
  theta_min = 0.08,
  phi_del = 2^(-0.25),
  phi_amp = 2^(0.25),
  t = 1e-05,
  mu = 0,
  sig = 1,
  gamma = 20,
  r = 0.015,
  debug = FALSE
)
}
\arguments{
\item{pAD}{integer vector Paternal allele counts}

\item{DP}{integer vector Total alelle counts}

\item{R}{numeric vector Variant mapping bias direction}

\item{p_s}{numeric vector Phase switch probabilities}

\item{Y_obs}{numeric vector Observed gene counts}

\item{lambda_ref}{numeric vector Reference expression rates}

\item{d_total}{integer Total library size for expression counts}

\item{theta_min}{numeric Minimum haplotype imbalance threshold}

\item{phi_del}{numeric Expected fold change for deletion}

\item{phi_amp}{numeric Expected fold change for amplification}

\item{t}{numeric Transition probability between copy number states}

\item{mu}{numeric Global expression bias}

\item{sig}{numeric Global expression variance}

\item{gamma}{numeric Overdispersion in the allele-specific expression}

\item{r}{numeric Variant mapping bias}

\item{debug}{logical Whether to print debug messages}
}
\value{
character vector Decoded states
}
\description{
Run 7-state joint HMM on a pseudobulk profile
}
\keyword{internal}
