% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rulefit.R
\name{h2o.predict_rules}
\alias{h2o.predict_rules}
\title{Evaluates validity of the given rules on the given data. Returns a frame with a column per each input rule id, 
representing a flag whether given rule is applied to the observation or not.}
\usage{
h2o.predict_rules(model, frame, rule_ids)
}
\arguments{
\item{model}{A trained rulefit model.}

\item{frame}{A frame on which rule validity is to be evaluated}

\item{rule_ids}{Rule ids to be evaluated against the frame}
}
\description{
Evaluates validity of the given rules on the given data. Returns a frame with a column per each input rule id, 
representing a flag whether given rule is applied to the observation or not.
}
\examples{
\dontrun{
library(h2o)
h2o.init()
titanic <- h2o.importFile(
 "https://s3.amazonaws.com/h2o-public-test-data/smalldata/gbm_test/titanic.csv"
)
response = "survived"
predictors <- c("age", "sibsp", "parch", "fare", "sex", "pclass")
titanic[,response] <- as.factor(titanic[,response])
titanic[,"pclass"] <- as.factor(titanic[,"pclass"])

splits <- h2o.splitFrame(data = titanic, ratios = .8, seed = 1234)
train <- splits[[1]]
test <- splits[[2]]

rfit <- h2o.rulefit(y = response, x = predictors, training_frame = train, validation_frame = test, 
min_rule_length = 1, max_rule_length = 10, max_num_rules = 100, seed = 1, model_type="rules")
h2o.predict_rules(rfit, train, c("M1T0N7, M1T49N7, M1T16N7", "M1T36N7", "M2T19N19"))
}
}
