% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infogram.R
\name{h2o.infogram}
\alias{h2o.infogram}
\title{H2O Infogram}
\usage{
h2o.infogram(
  x,
  y,
  training_frame,
  model_id = NULL,
  validation_frame = NULL,
  seed = -1,
  keep_cross_validation_models = TRUE,
  keep_cross_validation_predictions = FALSE,
  keep_cross_validation_fold_assignment = FALSE,
  nfolds = 0,
  fold_assignment = c("AUTO", "Random", "Modulo", "Stratified"),
  fold_column = NULL,
  ignore_const_cols = TRUE,
  score_each_iteration = FALSE,
  offset_column = NULL,
  weights_column = NULL,
  standardize = FALSE,
  distribution = c("AUTO", "bernoulli", "multinomial", "gaussian", "poisson", "gamma",
    "tweedie", "laplace", "quantile", "huber"),
  plug_values = NULL,
  max_iterations = 0,
  stopping_rounds = 0,
  stopping_metric = c("AUTO", "deviance", "logloss", "MSE", "RMSE", "MAE", "RMSLE",
    "AUC", "AUCPR", "lift_top_group", "misclassification", "mean_per_class_error",
    "custom", "custom_increasing"),
  stopping_tolerance = 0.001,
  balance_classes = FALSE,
  class_sampling_factors = NULL,
  max_after_balance_size = 5,
  max_runtime_secs = 0,
  custom_metric_func = NULL,
  auc_type = c("AUTO", "NONE", "MACRO_OVR", "WEIGHTED_OVR", "MACRO_OVO", "WEIGHTED_OVO"),
  algorithm = c("AUTO", "deeplearning", "drf", "gbm", "glm", "xgboost"),
  algorithm_params = NULL,
  protected_columns = NULL,
  total_information_threshold = -1,
  net_information_threshold = -1,
  relevance_index_threshold = -1,
  safety_index_threshold = -1,
  data_fraction = 1,
  top_n_features = 50
)
}
\arguments{
\item{x}{(Optional) A vector containing the names or indices of the predictor variables to use in building the model.
If x is missing, then all columns except y are used.}

\item{y}{The name or column index of the response variable in the data. 
The response must be either a numeric or a categorical/factor variable. 
If the response is numeric, then a regression model will be trained, otherwise it will train a classification model.}

\item{training_frame}{Id of the training data frame.}

\item{model_id}{Destination id for this model; auto-generated if not specified.}

\item{validation_frame}{Id of the validation data frame.}

\item{seed}{Seed for random numbers (affects certain parts of the algo that are stochastic and those might or might not be enabled by default).
Defaults to -1 (time-based random number).}

\item{keep_cross_validation_models}{\code{Logical}. Whether to keep the cross-validation models. Defaults to TRUE.}

\item{keep_cross_validation_predictions}{\code{Logical}. Whether to keep the predictions of the cross-validation models. Defaults to FALSE.}

\item{keep_cross_validation_fold_assignment}{\code{Logical}. Whether to keep the cross-validation fold assignment. Defaults to FALSE.}

\item{nfolds}{Number of folds for K-fold cross-validation (0 to disable or >= 2). Defaults to 0.}

\item{fold_assignment}{Cross-validation fold assignment scheme, if fold_column is not specified. The 'Stratified' option will
stratify the folds based on the response variable, for classification problems. Must be one of: "AUTO",
"Random", "Modulo", "Stratified". Defaults to AUTO.}

\item{fold_column}{Column with cross-validation fold index assignment per observation.}

\item{ignore_const_cols}{\code{Logical}. Ignore constant columns. Defaults to TRUE.}

\item{score_each_iteration}{\code{Logical}. Whether to score during each iteration of model training. Defaults to FALSE.}

\item{offset_column}{Offset column. This will be added to the combination of columns before applying the link function.}

\item{weights_column}{Column with observation weights. Giving some observation a weight of zero is equivalent to excluding it from
the dataset; giving an observation a relative weight of 2 is equivalent to repeating that row twice. Negative
weights are not allowed. Note: Weights are per-row observation weights and do not increase the size of the
data frame. This is typically the number of times a row is repeated, but non-integer values are supported as
well. During training, rows with higher weights matter more, due to the larger loss function pre-factor. If
you set weight = 0 for a row, the returned prediction frame at that row is zero and this is incorrect. To get
an accurate prediction, remove all rows with weight == 0.}

\item{standardize}{\code{Logical}. Standardize numeric columns to have zero mean and unit variance. Defaults to FALSE.}

\item{distribution}{Distribution function Must be one of: "AUTO", "bernoulli", "multinomial", "gaussian", "poisson", "gamma",
"tweedie", "laplace", "quantile", "huber". Defaults to AUTO.}

\item{plug_values}{Plug Values (a single row frame containing values that will be used to impute missing values of the
training/validation frame, use with conjunction missing_values_handling = PlugValues).}

\item{max_iterations}{Maximum number of iterations. Defaults to 0.}

\item{stopping_rounds}{Early stopping based on convergence of stopping_metric. Stop if simple moving average of length k of the
stopping_metric does not improve for k:=stopping_rounds scoring events (0 to disable) Defaults to 0.}

\item{stopping_metric}{Metric to use for early stopping (AUTO: logloss for classification, deviance for regression and anomaly_score
for Isolation Forest). Note that custom and custom_increasing can only be used in GBM and DRF with the Python
client. Must be one of: "AUTO", "deviance", "logloss", "MSE", "RMSE", "MAE", "RMSLE", "AUC", "AUCPR",
"lift_top_group", "misclassification", "mean_per_class_error", "custom", "custom_increasing". Defaults to
AUTO.}

\item{stopping_tolerance}{Relative tolerance for metric-based stopping criterion (stop if relative improvement is not at least this
much) Defaults to 0.001.}

\item{balance_classes}{\code{Logical}. Balance training data class counts via over/under-sampling (for imbalanced data). Defaults to
FALSE.}

\item{class_sampling_factors}{Desired over/under-sampling ratios per class (in lexicographic order). If not specified, sampling factors will
be automatically computed to obtain class balance during training. Requires balance_classes.}

\item{max_after_balance_size}{Maximum relative size of the training data after balancing class counts (can be less than 1.0). Requires
balance_classes. Defaults to 5.0.}

\item{max_runtime_secs}{Maximum allowed runtime in seconds for model training. Use 0 to disable. Defaults to 0.}

\item{custom_metric_func}{Reference to custom evaluation function, format: `language:keyName=funcName`}

\item{auc_type}{Set default multinomial AUC type. Must be one of: "AUTO", "NONE", "MACRO_OVR", "WEIGHTED_OVR", "MACRO_OVO",
"WEIGHTED_OVO". Defaults to AUTO.}

\item{algorithm}{Type of machine learning algorithm used to build the infogram. Options include 'AUTO' (gbm), 'deeplearning'
(Deep Learning with default parameters), 'drf' (Random Forest with default parameters), 'gbm' (GBM with
default parameters), 'glm' (GLM with default parameters), or 'xgboost' (if available, XGBoost with default
parameters). Must be one of: "AUTO", "deeplearning", "drf", "gbm", "glm", "xgboost". Defaults to AUTO.}

\item{algorithm_params}{Customized parameters for the machine learning algorithm specified in the algorithm parameter.}

\item{protected_columns}{Columns that contain features that are sensitive and need to be protected (legally, or otherwise), if
applicable. These features (e.g. race, gender, etc) should not drive the prediction of the response.}

\item{total_information_threshold}{A number between 0 and 1 representing a threshold for total information, defaulting to 0.1. For a specific
feature, if the total information is higher than this threshold, and the corresponding net information is also
higher than the threshold ``net_information_threshold``, that feature will be considered admissible. The total
information is the x-axis of the Core Infogram. Default is -1 which gets set to 0.1. Defaults to -1.}

\item{net_information_threshold}{A number between 0 and 1 representing a threshold for net information, defaulting to 0.1.  For a specific
feature, if the net information is higher than this threshold, and the corresponding total information is also
higher than the total_information_threshold, that feature will be considered admissible. The net information
is the y-axis of the Core Infogram. Default is -1 which gets set to 0.1. Defaults to -1.}

\item{relevance_index_threshold}{A number between 0 and 1 representing a threshold for the relevance index, defaulting to 0.1.  This is only
used when ``protected_columns`` is set by the user.  For a specific feature, if the relevance index value is
higher than this threshold, and the corresponding safety index is also higher than the
safety_index_threshold``, that feature will be considered admissible.  The relevance index is the x-axis of
the Fair Infogram. Default is -1 which gets set to 0.1. Defaults to -1.}

\item{safety_index_threshold}{A number between 0 and 1 representing a threshold for the safety index, defaulting to 0.1.  This is only used
when protected_columns is set by the user.  For a specific feature, if the safety index value is higher than
this threshold, and the corresponding relevance index is also higher than the relevance_index_threshold, that
feature will be considered admissible.  The safety index is the y-axis of the Fair Infogram. Default is -1
which gets set to 0.1. Defaults to -1.}

\item{data_fraction}{The fraction of training frame to use to build the infogram model. Defaults to 1.0, and any value greater than
0 and less than or equal to 1.0 is acceptable. Defaults to 1.}

\item{top_n_features}{An integer specifying the number of columns to evaluate in the infogram.  The columns are ranked by variable
importance, and the top N are evaluated.  Defaults to 50. Defaults to 50.}
}
\description{
The infogram is a graphical information-theoretic interpretability tool which allows the user to quickly spot the core, decision-making variables 
that uniquely and safely drive the response, in supervised classification problems. The infogram can significantly cut down the number of predictors needed to build 
a model by identifying only the most valuable, admissible features. When protected variables such as race or gender are present in the data, the admissibility 
of a variable is determined by a safety and relevancy index, and thus serves as a diagnostic tool for fairness. The safety of each feature can be quantified and 
variables that are unsafe will be considered inadmissible. Models built using only admissible features will naturally be more interpretable, given the reduced 
feature set.  Admissible models are also less susceptible to overfitting and train faster, while providing similar accuracy as models built using all available features.
}
\details{
The infogram allows the user to quickly spot the admissible decision-making variables that are driving the response.  
There are two types of infogram plots: Core and Fair Infogram.

The Core Infogram plots all the variables as points on two-dimensional grid of total vs net information.  The x-axis is total information, 
a measure of how much the variable drives the response (the more predictive, the higher the total information). 
The y-axis is net information, a measure of how unique the variable is.  The top right quadrant of the infogram plot is the admissible section; the variables
located in this quadrant are the admissible features.  In the Core Infogram, the admissible features are the strongest, unique drivers of 
the response.

If sensitive or protected variables are present in data, the user can specify which attributes should be protected while training using the \code{protected_columns} 
argument. All non-protected predictor variables will be checked to make sure that there's no information pathway to the response through a protected feature, and 
deemed inadmissible if they possess little or no informational value beyond their use as a dummy for protected attributes. The Fair Infogram plots all the features 
as points on two-dimensional grid of relevance vs safety.  The x-axis is relevance index, a measure of how much the variable drives the response (the more predictive, 
the higher the relevance). The y-axis is safety index, a measure of how much extra information the variable has that is not acquired through the protected variables.  
In the Fair Infogram, the admissible features are the strongest, safest drivers of the response.
}
\examples{
\dontrun{
h2o.init()

# Convert iris dataset to an H2OFrame    
df <- as.h2o(iris)

# Infogram
ig <- h2o.infogram(y = "Species", training_frame = df) 
plot(ig)

}
}
