% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gwrpv.R
\name{close_to_normal}
\alias{close_to_normal}
\title{This is a CLT-linked run-time control.}
\usage{
close_to_normal(totnobs, n0, n1, n2, pa, pb, mua, mub, siga, sigb, beta,
  nearnorm)
}
\arguments{
\item{totnobs}{the sum of n0, n1, n2}

\item{n0}{the major allele homozygotes}

\item{n1}{the major allele heterozygotes}

\item{n2}{the minor allele zygotes}

\item{pa}{parameter of the mixture distribution, a real number between zero and one with pa+pb=1}

\item{pb}{parameter of the mixture distribution, a real number between zero and one with pa+pb=1}

\item{mua}{parameter of the mixture distribution, can be any real number}

\item{mub}{parameter of the mixture distribution, can be any real number}

\item{siga}{parameter of the mixture distribution, can be any real number}

\item{sigb}{parameter of the mixture distribution, can be any real number}

\item{beta}{the beta from the regression being tested}

\item{nearnorm}{must be in log base 10 format, with default value set to -5}
}
\value{
list(skewbeta = skewbeta, kurtbeta = kurtbeta, sigbeta = sigbeta, skipiter = skipiter)
}
\description{
If the number of observations is large enough that a normality approximation
holds for the y average across the major homozygote subsample, then the code skips the
time-consuming loop over n0, n1 and n2 and and uses the normal approximation for the average y
for the major homozygote subsample. The remaining loop is only over n1 and n2.
The only new input/output variables are input lognearnorm (the magnitude of maximum allowed
tolerance (in log 10 format) for the sum of squared deviation of skewness and
kurtosis from their normal values and output stopiter
(a zero if the code does not mandate a stop to the iterative estimation and a one if it does).
The input variable lognearnorm has a default value set so that users only have to enter it if they want to over-ride the default value.
}

