% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runs.R
\name{runs_label}
\alias{runs_label}
\alias{runs_tag}
\alias{runs_mark}
\alias{runs_comment}
\title{Annotate runs}
\usage{
runs_label(runs = NULL, label = NULL, ..., clear = FALSE)

runs_tag(runs = NULL, add = NULL, ..., remove = NULL, clear = FALSE)

runs_mark(runs = NULL, ..., clear = FALSE)

runs_comment(runs = NULL, comment = NULL, ..., delete = NULL, clear = FALSE)
}
\arguments{
\item{runs}{a runs selection}

\item{label, comment}{a string}

\item{...}{passed on to \code{guild}. Pass \code{"--help"} to see all options.}

\item{clear}{bool, whether to clear the existing tags/comments/label.}

\item{add, remove}{a character vector of tags to add or remove}

\item{delete}{integer vector, which comment(s) to delete,
corresponding to the row number(s) in the dataframe found at
\code{runs_info()$comments}.}
}
\value{
The value supplied to the \code{runs} argument, invisibly.
}
\description{
Annotate runs
}
\details{
Annotation types and their recommended uses:
\itemize{
\item \strong{labels}: short, single line descriptions tailored for readability,
not programmatic consumption. Labels are presented prominently in
\code{guild_view()} and other run views.
\item \strong{tags}: short single-token strings. Tags can be used for organizing, grouping,
and filtering runs.
\item \strong{comments}: longer (potentially multi-paragraph) descriptions of the
run. Guild stores and presents run comments as log entries,
complete with timestamps and author info.
\item \strong{marks}: A boolean attribute of a run (a run can be marked or unmarked).
Marked runs are primarily used to declare a run as the preferred
source for resolving an operation dependency. If a operation
declares a dependency on another operation, and one of the
dependent operation runs is marked, the marked run is used rather
than the latest run for resolving the dependency. Marks can also be
a convenient mechanism for ad-hoc filtering operations, but in
general, tags are preferred over marks for this.
}
}
\note{
\code{runs_comment()} will open up an editor if \code{comment} is not
supplied.
}
\examples{
\dontrun{
runs_info(1) \%>\% runs_tag(clear = TRUE)
runs_info(1) \%>\% runs_tag("foo")
runs_info(1)$tags
runs_info(1) \%>\% runs_tag("bar")
runs_info(1)$tags
runs_info(1) \%>\% runs_tag(remove = "foo")
runs_info(1)$tags
runs_info(1) \%>\% runs_tag("baz", clear = TRUE)
runs_info(1)$tags

## pass through options to `guild tag` cli subcommand
runs_tag("--help")
}
}
