% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guild.R
\name{guild_merge}
\alias{guild_merge}
\title{Copy run files into the current project working directory}
\usage{
guild_merge(run = NULL, ...)
}
\arguments{
\item{run}{a run selection}

\item{...}{
  Arguments passed on to \code{\link[=guild_merge_cli]{guild_merge_cli}}
  \describe{
    \item{\code{filter}}{Filter runs using a filter expression. See Filter by Expression above for details.}
    \item{\code{operation}}{Filter runs with operations matching \code{VAL}.}
    \item{\code{label}}{Filter runs with labels matching VAL. To show unlabeled runs, use \code{unlabeled}.}
    \item{\code{unlabeled}}{(bool) Filter runs without labels.}
    \item{\code{tag}}{Filter runs with TAG.}
    \item{\code{comment}}{Filter runs with comments matching VAL.}
    \item{\code{marked}}{(bool) Filter marked runs.}
    \item{\code{unmarked}}{(bool) Filter unmarked runs.}
    \item{\code{started}}{Filter runs started within RANGE. See above for valid time ranges.}
    \item{\code{digest}}{Filter runs with a matching source code digest.}
    \item{\code{running}}{(bool) Filter runs that are still running.}
    \item{\code{completed}}{(bool) Filter completed runs.}
    \item{\code{error}}{(bool) Filter runs that exited with an error.}
    \item{\code{terminated}}{(bool) Filter runs terminated by the user.}
    \item{\code{pending}}{(bool) Filter pending runs.}
    \item{\code{staged}}{(bool) Filter staged runs.}
    \item{\code{target_dir}}{Directory to merge run files to (required if project directory cannot be determined for the run).}
    \item{\code{sourcecode}}{(bool) Only copy run source code. Implies use of \code{skip_deps}. Cannot be used with \code{skip_sourcecode}.}
    \item{\code{all}}{(bool) Copy all run files. May be used with \code{skip_sourcecode}, \code{skip_deps}, and \code{exclude} to copy all but the skipped/excluded files.}
    \item{\code{skip_sourcecode}}{(bool) Don't copy run source code.}
    \item{\code{skip_deps}}{(bool) Don't copy project-local dependencies.}
    \item{\code{exclude}}{Exclude a file or pattern (may be used multiple times).}
    \item{\code{no_summary}}{(bool) Don't generate a run summary.}
    \item{\code{summary_name}}{Name used for the run summary. Use '${run_id}' in the name to include the run ID.}
    \item{\code{preview}}{(bool) Show what would happen on a merge.}
    \item{\code{replace}}{(bool) Allow replacement of existing files. Cannot be used with \code{no_replace}}
    \item{\code{no_replace}}{(bool) Fail if any target file would be replaced, even if that file is committed to the project VCS. Cannot be used with \code{replace}.}
  }}
}
\value{
\code{NULL}, invisibly. This function is called for its
side effect.
}
\description{
Copy run files into the current project working directory
}
\examples{
\dontrun{
guild_merge("--help")
runs_scalars() \%>\%
  dplyr::slice_max("epoch_acc") \%>\%
  guild_merge(I("--yes --replace"))
}
}
