% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_CT_from_entropy}
\alias{gsw_CT_from_entropy}
\title{Conservative Temperature from Entropy}
\usage{
gsw_CT_from_entropy(SA, entropy)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ].  The valid range for most `gsw`
functions is 0 to 42 g/kg.}

\item{entropy}{specific entropy [ J/(degC*kg) ]}
}
\value{
Conservative Temperature [ degC ]
}
\description{
Conservative Temperature from Entropy
}
\section{Implementation Note}{


This R function uses a wrapper to a C function contained within the GSW-C
system as updated 2022-10-11 at \url{https://github.com/TEOS-10/GSW-C} with
git commit `657216dd4f5ea079b5f0e021a4163e2d26893371`.

The C function uses data from the \code{library/gsw_data_v3_0.mat}
file provided in the GSW-Matlab source code, version 3.06-11.
Unfortunately, this version of the mat file is no longer displayed on the
TEOS-10.org website.  Therefore, in the interests of making GSW-R be
self-contained, a copy was downloaded from
\url{http://www.teos-10.org/software/gsw_matlab_v3_06_11.zip} on 2022-05-25,
the .mat file was stored in the developer/create_data directory of
\url{https://github.com/TEOS-10/GSW-R}, and then the dataset used in GSW-R
was created based on that .mat file.

Please consult \url{http://www.teos-10.org} to learn more about the various
TEOS-10 software systems.
}

\examples{
SA <- c(      34.7118,  34.8915,  35.0256,  34.8472, 34.7366, 34.7324)
entropy <- c(400.3892, 395.4378, 319.8668, 146.7910, 98.6471, 62.7919)
CT <- gsw_CT_from_entropy(SA, entropy)
stopifnot(all.equal(CT, c(28.809902787278070, 28.439199226786918, 22.786199266954270,
                          10.226197672488652, 6.827196739780282, 4.323602945446461)))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_CT_from_entropy.html}
}
\seealso{
Other things related to entropy: 
\code{\link{gsw_entropy_first_derivatives}()},
\code{\link{gsw_entropy_from_pt}()},
\code{\link{gsw_entropy_from_t}()},
\code{\link{gsw_entropy_ice}()},
\code{\link{gsw_pt_from_entropy}()}
}
\concept{things related to entropy}
