% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igroup.R
\name{group_by2}
\alias{group_by2}
\title{Group a Tibble With Inapplicable Groups}
\usage{
group_by2(data, ...)
}
\arguments{
\item{data}{A tibble to group}

\item{...}{Arguments of the form \code{var = c(val1, val2)} or the name of a variable}
}
\value{
An igrouped tibble
}
\description{
Similar to \code{dplyr::group_by()}, this function groups a
tibble while also marking certain groups as inapplicable.
}
\details{
A grouped tibble has one or more grouping variables, where each unique
combination of values identifies a group. This function allows some of
the values to be marked inapplicable, such that the corresponding rows
are not considered to be grouped on that variable at all.

Grouping variables, and inapplicable values, are passed as arguments in
the form \code{group_var = c(value1, value2, ...)}. Any included values
will be marked inapplicable. If an argument has length 0 or is NULL, no
values will be marked inapplicable.
}
