% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_process.R
\name{assign_groups}
\alias{assign_groups}
\title{Assigns model result to the original data frame.}
\usage{
assign_groups(
  model_result,
  assignment = c("diversity", "preference"),
  dframe,
  params_list,
  group_names
)
}
\arguments{
\item{model_result}{The output solution objection.}

\item{assignment}{Character string indicating the type of model that this
dataset is for. The argument is either 'preference' or 'diversity'. Partial
matching is fine.}

\item{dframe}{The original dataframe used in \code{\link[=extract_student_info]{extract_student_info()}}.}

\item{params_list}{The list of parameters from the YAML file, i.e. the output
of \code{\link[=extract_params_yaml]{extract_params_yaml()}}. This is only required for the preference-based
assignment.}

\item{group_names}{A character string. It denotes the column name in the
original dataframe containing the self-formed groups. Note that we need the
string here, not the integer position, since we are going to join with it.}
}
\value{
A data frame with the group assignments attached to the original
group composition dataframe.
}
\description{
From the result of \code{\link[ompr:solve_model]{ompr::solve_model()}}, this function attaches the
derived groupings to the original dataframe comprising students.
}
