library(groupdata2)
context("summarize_balances()")


test_that("fuzz testing check_summarize_balances_()", {

  xpectr::set_test_seed(42)

  # Regression tests

  # The dataset from the example
  df <- data.frame(
    "some_var" = runif(25),
    "some_factor" = factor(sample(1:3, size = 25, replace=TRUE)),
    "some_id" = factor(sample(1:7, size = 25, replace=TRUE)),
    "grp_1" = factor(sample(1:5, size = 25, replace=TRUE)),
    "grp_2" = factor(sample(1:8, size = 25, replace=TRUE)),
    "grp_3" = factor(sample(LETTERS[1:3], size = 25, replace=TRUE)),
    "grp_4" = factor(sample(LETTERS[1:12], size = 25, replace=TRUE))
  )

  # Generate expectations for 'check_summarize_balances_'
  # Tip: comment out the gxs_function() call
  # so it is easy to regenerate the tests
  xpectr::set_test_seed(42)
  # xpectr::gxs_function(
  #   fn = check_summarize_balances_,
  #   args_values = list(
  #     "data" = list(df, head(df, 1), c(1,2,3), NA),
  #     "group_cols" = list(c("grp_1", "grp_2"), "some_var", "sdf", NA),
  #     "cat_cols" = list("some_factor", "some_var", "sdf", 1, NA),
  #     "num_cols" = list("some_var", "some_factor", "sdf", 1, NA),
  #     "id_cols" = list("some_id", "some_var", "sdf", 1, NA),
  #     "summarize_size" = list(TRUE, FALSE, 2, NA),
  #     "include_normalized" = list(FALSE, TRUE, 2, NA),
  #     "rank_weights" = list(NULL, c("size" = 2), c("size" = NA), 2, NA),
  #     "cat_levels_rank_weights" = list(NULL), # TODO
  #     "num_normalize_fn" = list(function(x) {
  #       rearrr::min_max_scale(
  #         x,
  #         old_min = quantile(x,
  #                            0.025),
  #         old_max = quantile(x, 0.975),
  #         new_min = 0,
  #         new_max = 1
  #       )
  #     }, standardize_, 2, NA)
  #   ),
  #   indentation = 2,
  #   copy_env = FALSE
  # )


  ## Testing 'check_summarize_balances_'                                      ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing check_summarize_balances_(data = df, group_c...
  xpectr::set_test_seed(42)
  # Testing is NULL
  expect_true(
    is.null(check_summarize_balances_(data = df, group_cols = c("grp_1", "grp_2"), cat_cols = "some_factor", num_cols = "some_var", id_cols = "some_id", summarize_size = TRUE, include_normalized = FALSE, rank_weights = NULL, cat_levels_rank_weights = NULL, num_normalize_fn = function(x) {
      rearrr::min_max_scale(x, old_min = quantile(x, 0.025), old_max = quantile(x,
          0.975), new_min = 0, new_max = 1)
  })))

  # Testing check_summarize_balances_(data = head(df, 1)...
  # Changed from baseline: data = head(df, 1)
  xpectr::set_test_seed(42)
  # Testing is NULL
  expect_true(
    is.null(check_summarize_balances_(data = head(df, 1), group_cols = c("grp_1", "grp_2"), cat_cols = "some_factor", num_cols = "some_var", id_cols = "some_id", summarize_size = TRUE, include_normalized = FALSE, rank_weights = NULL, cat_levels_rank_weights = NULL, num_normalize_fn = function(x) {
      rearrr::min_max_scale(x, old_min = quantile(x, 0.025), old_max = quantile(x,
          0.975), new_min = 0, new_max = 1)
  })))

  # Testing check_summarize_balances_(data = c(1, 2, 3),...
  # Changed from baseline: data = c(1, 2, 3)
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12861 <- xpectr::capture_side_effects(check_summarize_balances_(data = c(1, 2, 3), group_cols = c("grp_1", "grp_2"), cat_cols = "some_factor", num_cols = "some_var", id_cols = "some_id", summarize_size = TRUE, include_normalized = FALSE, rank_weights = NULL, cat_levels_rank_weights = NULL, num_normalize_fn = function(x) {
      rearrr::min_max_scale(x, old_min = quantile(x, 0.025), old_max = quantile(x,
          0.975), new_min = 0, new_max = 1)
  }), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'data': Must be of type 'data.frame', not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing check_summarize_balances_(data = NA, group_c...
  # Changed from baseline: data = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18304 <- xpectr::capture_side_effects(check_summarize_balances_(data = NA, group_cols = c("grp_1", "grp_2"), cat_cols = "some_factor", num_cols = "some_var", id_cols = "some_id", summarize_size = TRUE, include_normalized = FALSE, rank_weights = NULL, cat_levels_rank_weights = NULL, num_normalize_fn = function(x) {
      rearrr::min_max_scale(x, old_min = quantile(x, 0.025), old_max = quantile(x,
          0.975), new_min = 0, new_max = 1)
  }), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'data': Must be of type 'data.frame', not 'logical'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing check_summarize_balances_(data = NULL, group...
  # Changed from baseline: data = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16417 <- xpectr::capture_side_effects(check_summarize_balances_(data = NULL, group_cols = c("grp_1", "grp_2"), cat_cols = "some_factor", num_cols = "some_var", id_cols = "some_id", summarize_size = TRUE, include_normalized = FALSE, rank_weights = NULL, cat_levels_rank_weights = NULL, num_normalize_fn = function(x) {
      rearrr::min_max_scale(x, old_min = quantile(x, 0.025), old_max = quantile(x,
          0.975), new_min = 0, new_max = 1)
  }), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'data': Must be of type 'data.frame', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing check_summarize_balances_(data = df, group_c...
  # Changed from baseline: group_cols = "some_var"
  xpectr::set_test_seed(42)
  # Testing is NULL
  expect_true(
    is.null(check_summarize_balances_(data = df, group_cols = "some_var", cat_cols = "some_factor", num_cols = "some_var", id_cols = "some_id", summarize_size = TRUE, include_normalized = FALSE, rank_weights = NULL, cat_levels_rank_weights = NULL, num_normalize_fn = function(x) {
      rearrr::min_max_scale(x, old_min = quantile(x, 0.025), old_max = quantile(x,
          0.975), new_min = 0, new_max = 1)
  })))

  # Testing check_summarize_balances_(data = df, group_c...
  # Changed from baseline: group_cols = "sdf"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17365 <- xpectr::capture_side_effects(check_summarize_balances_(data = df, group_cols = "sdf", cat_cols = "some_factor", num_cols = "some_var", id_cols = "some_id", summarize_size = TRUE, include_normalized = FALSE, rank_weights = NULL, cat_levels_rank_weights = NULL, num_normalize_fn = function(x) {
      rearrr::min_max_scale(x, old_min = quantile(x, 0.025), old_max = quantile(x,
          0.975), new_min = 0, new_max = 1)
  }), reset_seed = TRUE)
  expect_match(
    xpectr::strip(side_effects_17365[['error']], lowercase = TRUE),
    xpectr::strip(
      ifelse(
        is_checkmate_v2_1(),
        "must include the elements {'sdf','some_factor','some_var','some_id'}, but is missing elements {'sdf'}.",
        "must include the elements {'sdf','some_factor','some_var','some_id'}"
      ), lowercase = TRUE
    ),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17365[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing check_summarize_balances_(data = df, group_c...
  # Changed from baseline: group_cols = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11346 <- xpectr::capture_side_effects(check_summarize_balances_(data = df, group_cols = NA, cat_cols = "some_factor", num_cols = "some_var", id_cols = "some_id", summarize_size = TRUE, include_normalized = FALSE, rank_weights = NULL, cat_levels_rank_weights = NULL, num_normalize_fn = function(x) {
      rearrr::min_max_scale(x, old_min = quantile(x, 0.025), old_max = quantile(x,
          0.975), new_min = 0, new_max = 1)
  }), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'group_cols': Contains missing values (element 1)."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing check_summarize_balances_(data = df, group_c...
  # Changed from baseline: group_cols = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16569 <- xpectr::capture_side_effects(check_summarize_balances_(data = df, group_cols = NULL, cat_cols = "some_factor", num_cols = "some_var", id_cols = "some_id", summarize_size = TRUE, include_normalized = FALSE, rank_weights = NULL, cat_levels_rank_weights = NULL, num_normalize_fn = function(x) {
      rearrr::min_max_scale(x, old_min = quantile(x, 0.025), old_max = quantile(x,
          0.975), new_min = 0, new_max = 1)
  }), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'group_cols': Must be of type 'character', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing check_summarize_balances_(data = df, group_c...
  # Changed from baseline: cat_cols = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17050 <- xpectr::capture_side_effects(check_summarize_balances_(data = df, group_cols = c("grp_1", "grp_2"), cat_cols = NA, num_cols = "some_var", id_cols = "some_id", summarize_size = TRUE, include_normalized = FALSE, rank_weights = NULL, cat_levels_rank_weights = NULL, num_normalize_fn = function(x) {
      rearrr::min_max_scale(x, old_min = quantile(x, 0.025), old_max = quantile(x,
          0.975), new_min = 0, new_max = 1)
  }), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'cat_cols': Contains missing values (element 1)."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing check_summarize_balances_(data = df, group_c...
  # Changed from baseline: cat_cols = "some_var"
  xpectr::set_test_seed(42)
  # Testing is NULL
  expect_true(
    is.null(check_summarize_balances_(data = df, group_cols = c("grp_1", "grp_2"), cat_cols = "some_var", num_cols = "some_var", id_cols = "some_id", summarize_size = TRUE, include_normalized = FALSE, rank_weights = NULL, cat_levels_rank_weights = NULL, num_normalize_fn = function(x) {
      rearrr::min_max_scale(x, old_min = quantile(x, 0.025), old_max = quantile(x,
          0.975), new_min = 0, new_max = 1)
  })))

  # Testing check_summarize_balances_(data = df, group_c...
  # Changed from baseline: cat_cols = "sdf"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17191 <- xpectr::capture_side_effects(check_summarize_balances_(data = df, group_cols = c("grp_1", "grp_2"), cat_cols = "sdf", num_cols = "some_var", id_cols = "some_id", summarize_size = TRUE, include_normalized = FALSE, rank_weights = NULL, cat_levels_rank_weights = NULL, num_normalize_fn = function(x) {
      rearrr::min_max_scale(x, old_min = quantile(x, 0.025), old_max = quantile(x,
          0.975), new_min = 0, new_max = 1)
  }), reset_seed = TRUE)
  expect_match(
    xpectr::strip(side_effects_17191[['error']], lowercase = TRUE),
    xpectr::strip(
      ifelse(
        is_checkmate_v2_1(),
        "1 assertions failed:\n * Variable 'colnames(data)': Names must include the elements {'grp_1','grp_2','sdf','some_var','some_id'}, but is missing elements {'sdf'}.",
        "must include the elements {'grp_1','grp_2','sdf','some_var','some_id'}"
      ), lowercase = TRUE
    ),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17191[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing check_summarize_balances_(data = df, group_c...
  # Changed from baseline: cat_cols = 1
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19346 <- xpectr::capture_side_effects(check_summarize_balances_(data = df, group_cols = c("grp_1", "grp_2"), cat_cols = 1, num_cols = "some_var", id_cols = "some_id", summarize_size = TRUE, include_normalized = FALSE, rank_weights = NULL, cat_levels_rank_weights = NULL, num_normalize_fn = function(x) {
      rearrr::min_max_scale(x, old_min = quantile(x, 0.025), old_max = quantile(x,
          0.975), new_min = 0, new_max = 1)
  }), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'cat_cols': Must be of type 'character' (or 'NULL'), not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing check_summarize_balances_(data = df, group_c...
  # Changed from baseline: cat_cols = NULL
  xpectr::set_test_seed(42)
  # Testing is NULL
  expect_true(
    is.null(check_summarize_balances_(data = df, group_cols = c("grp_1", "grp_2"), cat_cols = NULL, num_cols = "some_var", id_cols = "some_id", summarize_size = TRUE, include_normalized = FALSE, rank_weights = NULL, cat_levels_rank_weights = NULL, num_normalize_fn = function(x) {
      rearrr::min_max_scale(x, old_min = quantile(x, 0.025), old_max = quantile(x,
          0.975), new_min = 0, new_max = 1)
  })))

  # Testing check_summarize_balances_(data = df, group_c...
  # Changed from baseline: num_cols = "some_factor"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11346 <- xpectr::capture_side_effects(check_summarize_balances_(data = df, group_cols = c("grp_1", "grp_2"), cat_cols = "some_factor", num_cols = "some_factor", id_cols = "some_id", summarize_size = TRUE, include_normalized = FALSE, rank_weights = NULL, cat_levels_rank_weights = NULL, num_normalize_fn = function(x) {
      rearrr::min_max_scale(x, old_min = quantile(x, 0.025), old_max = quantile(x,0.975), new_min = 0, new_max = 1)}), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'data[['some_factor']]': Must be of type 'numeric', not 'factor'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)
  ## Finished testing 'check_summarize_balances_(data = df, group_c...'     ####

  # Testing check_summarize_balances_(data = df, group_c...
  # Changed from baseline: num_cols = "sdf"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19400 <- xpectr::capture_side_effects(check_summarize_balances_(data = df, group_cols = c("grp_1", "grp_2"), cat_cols = "some_factor", num_cols = "sdf", id_cols = "some_id", summarize_size = TRUE, include_normalized = FALSE, rank_weights = NULL, cat_levels_rank_weights = NULL, num_normalize_fn = function(x) {
      rearrr::min_max_scale(x, old_min = quantile(x, 0.025), old_max = quantile(x,
          0.975), new_min = 0, new_max = 1)
  }), reset_seed = TRUE)
  expect_match(
    xpectr::strip(side_effects_19400[['error']], lowercase = TRUE),
    xpectr::strip(
      ifelse(
        is_checkmate_v2_1(),
        "assertions failed:\n * Variable 'colnames(data)': Names must include the elements {'grp_1','grp_2','some_factor','sdf','some_id'}, but is missing elements {'sdf'}.",
        "must include the elements {'grp_1','grp_2','some_factor','sdf','some_id'}"
      ), lowercase = TRUE
    ),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19400[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing check_summarize_balances_(data = df, group_c...
  # Changed from baseline: num_cols = 1
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19782 <- xpectr::capture_side_effects(check_summarize_balances_(data = df, group_cols = c("grp_1", "grp_2"), cat_cols = "some_factor", num_cols = 1, id_cols = "some_id", summarize_size = TRUE, include_normalized = FALSE, rank_weights = NULL, cat_levels_rank_weights = NULL, num_normalize_fn = function(x) {
      rearrr::min_max_scale(x, old_min = quantile(x, 0.025), old_max = quantile(x,
          0.975), new_min = 0, new_max = 1)
  }), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19782[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'num_cols': Must be of type 'character' (or 'NULL'), not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19782[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing check_summarize_balances_(data = df, group_c...
  # Changed from baseline: num_cols = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11174 <- xpectr::capture_side_effects(check_summarize_balances_(data = df, group_cols = c("grp_1", "grp_2"), cat_cols = "some_factor", num_cols = NA, id_cols = "some_id", summarize_size = TRUE, include_normalized = FALSE, rank_weights = NULL, cat_levels_rank_weights = NULL, num_normalize_fn = function(x) {
      rearrr::min_max_scale(x, old_min = quantile(x, 0.025), old_max = quantile(x,
          0.975), new_min = 0, new_max = 1)
  }), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11174[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'num_cols': Contains missing values (element 1)."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11174[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing check_summarize_balances_(data = df, group_c...
  # Changed from baseline: num_cols = NULL
  xpectr::set_test_seed(42)
  # Testing is NULL
  expect_true(
    is.null(check_summarize_balances_(data = df, group_cols = c("grp_1", "grp_2"), cat_cols = "some_factor", num_cols = NULL, id_cols = "some_id", summarize_size = TRUE, include_normalized = FALSE, rank_weights = NULL, cat_levels_rank_weights = NULL, num_normalize_fn = function(x) {
      rearrr::min_max_scale(x, old_min = quantile(x, 0.025), old_max = quantile(x,
          0.975), new_min = 0, new_max = 1)
  })))

  # Testing check_summarize_balances_(data = df, group_c...
  # Changed from baseline: id_cols = "some_var"
  xpectr::set_test_seed(42)
  # Testing is NULL
  expect_true(
    is.null(check_summarize_balances_(data = df, group_cols = c("grp_1", "grp_2"), cat_cols = "some_factor", num_cols = "some_var", id_cols = "some_var", summarize_size = TRUE, include_normalized = FALSE, rank_weights = NULL, cat_levels_rank_weights = NULL, num_normalize_fn = function(x) {
      rearrr::min_max_scale(x, old_min = quantile(x, 0.025), old_max = quantile(x,
          0.975), new_min = 0, new_max = 1)
  })))

  # Testing check_summarize_balances_(data = df, group_c...
  # Changed from baseline: id_cols = "sdf"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19040 <- xpectr::capture_side_effects(check_summarize_balances_(data = df, group_cols = c("grp_1", "grp_2"), cat_cols = "some_factor", num_cols = "some_var", id_cols = "sdf", summarize_size = TRUE, include_normalized = FALSE, rank_weights = NULL, cat_levels_rank_weights = NULL, num_normalize_fn = function(x) {
      rearrr::min_max_scale(x, old_min = quantile(x, 0.025), old_max = quantile(x,
          0.975), new_min = 0, new_max = 1)
  }), reset_seed = TRUE)
  expect_match(
    xpectr::strip(side_effects_19040[['error']], lowercase = TRUE),
    xpectr::strip(
      ifelse(
        is_checkmate_v2_1(),
        "1 assertions failed:\n * Variable 'colnames(data)': Names must include the elements {'grp_1','grp_2','some_factor','some_var','sdf'}, but is missing elements {'sdf'}.",
        "must include the elements {'grp_1','grp_2','some_factor','some_var','sdf'}"
      ), lowercase = TRUE
    ),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19040[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing check_summarize_balances_(data = df, group_c...
  # Changed from baseline: id_cols = 1
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11387 <- xpectr::capture_side_effects(check_summarize_balances_(data = df, group_cols = c("grp_1", "grp_2"), cat_cols = "some_factor", num_cols = "some_var", id_cols = 1, summarize_size = TRUE, include_normalized = FALSE, rank_weights = NULL, cat_levels_rank_weights = NULL, num_normalize_fn = function(x) {
      rearrr::min_max_scale(x, old_min = quantile(x, 0.025), old_max = quantile(x,
          0.975), new_min = 0, new_max = 1)
  }), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11387[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'id_cols': Must be of type 'character' (or 'NULL'), not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11387[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing check_summarize_balances_(data = df, group_c...
  # Changed from baseline: id_cols = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19888 <- xpectr::capture_side_effects(check_summarize_balances_(data = df, group_cols = c("grp_1", "grp_2"), cat_cols = "some_factor", num_cols = "some_var", id_cols = NA, summarize_size = TRUE, include_normalized = FALSE, rank_weights = NULL, cat_levels_rank_weights = NULL, num_normalize_fn = function(x) {
      rearrr::min_max_scale(x, old_min = quantile(x, 0.025), old_max = quantile(x,
          0.975), new_min = 0, new_max = 1)
  }), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19888[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'id_cols': Contains missing values (element 1)."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19888[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing check_summarize_balances_(data = df, group_c...
  # Changed from baseline: id_cols = NULL
  xpectr::set_test_seed(42)
  # Testing is NULL
  expect_true(
    is.null(check_summarize_balances_(data = df, group_cols = c("grp_1", "grp_2"), cat_cols = "some_factor", num_cols = "some_var", id_cols = NULL, summarize_size = TRUE, include_normalized = FALSE, rank_weights = NULL, cat_levels_rank_weights = NULL, num_normalize_fn = function(x) {
      rearrr::min_max_scale(x, old_min = quantile(x, 0.025), old_max = quantile(x,
          0.975), new_min = 0, new_max = 1)
  })))

  # Testing check_summarize_balances_(data = df, group_c...
  # Changed from baseline: summarize_size = FALSE
  xpectr::set_test_seed(42)
  # Testing is NULL
  expect_true(
    is.null(check_summarize_balances_(data = df, group_cols = c("grp_1", "grp_2"), cat_cols = "some_factor", num_cols = "some_var", id_cols = "some_id", summarize_size = FALSE, include_normalized = FALSE, rank_weights = NULL, cat_levels_rank_weights = NULL, num_normalize_fn = function(x) {
      rearrr::min_max_scale(x, old_min = quantile(x, 0.025), old_max = quantile(x,
          0.975), new_min = 0, new_max = 1)
  })))

  # Testing check_summarize_balances_(data = df, group_c...
  # Changed from baseline: summarize_size = 2
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15142 <- xpectr::capture_side_effects(check_summarize_balances_(data = df, group_cols = c("grp_1", "grp_2"), cat_cols = "some_factor", num_cols = "some_var", id_cols = "some_id", summarize_size = 2, include_normalized = FALSE, rank_weights = NULL, cat_levels_rank_weights = NULL, num_normalize_fn = function(x) {
      rearrr::min_max_scale(x, old_min = quantile(x, 0.025), old_max = quantile(x,
          0.975), new_min = 0, new_max = 1)
  }), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15142[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'summarize_size': Must be of type 'logical flag', not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15142[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing check_summarize_balances_(data = df, group_c...
  # Changed from baseline: summarize_size = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_13902 <- xpectr::capture_side_effects(check_summarize_balances_(data = df, group_cols = c("grp_1", "grp_2"), cat_cols = "some_factor", num_cols = "some_var", id_cols = "some_id", summarize_size = NA, include_normalized = FALSE, rank_weights = NULL, cat_levels_rank_weights = NULL, num_normalize_fn = function(x) {
      rearrr::min_max_scale(x, old_min = quantile(x, 0.025), old_max = quantile(x,
          0.975), new_min = 0, new_max = 1)
  }), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13902[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'summarize_size': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13902[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing check_summarize_balances_(data = df, group_c...
  # Changed from baseline: summarize_size = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19057 <- xpectr::capture_side_effects(check_summarize_balances_(data = df, group_cols = c("grp_1", "grp_2"), cat_cols = "some_factor", num_cols = "some_var", id_cols = "some_id", summarize_size = NULL, include_normalized = FALSE, rank_weights = NULL, cat_levels_rank_weights = NULL, num_normalize_fn = function(x) {
      rearrr::min_max_scale(x, old_min = quantile(x, 0.025), old_max = quantile(x,
          0.975), new_min = 0, new_max = 1)
  }), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19057[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'summarize_size': Must be of type 'logical flag', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19057[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing check_summarize_balances_(data = df, group_c...
  # Changed from baseline: include_normalized = ...
  xpectr::set_test_seed(42)
  # Testing is NULL
  expect_true(
    is.null(check_summarize_balances_(data = df, group_cols = c("grp_1", "grp_2"), cat_cols = "some_factor", num_cols = "some_var", id_cols = "some_id", summarize_size = TRUE, include_normalized = TRUE, rank_weights = NULL, cat_levels_rank_weights = NULL, num_normalize_fn = function(x) {
      rearrr::min_max_scale(x, old_min = quantile(x, 0.025), old_max = quantile(x,
          0.975), new_min = 0, new_max = 1)
  })))

  # Testing check_summarize_balances_(data = df, group_c...
  # Changed from baseline: include_normalized = 2
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18360 <- xpectr::capture_side_effects(check_summarize_balances_(data = df, group_cols = c("grp_1", "grp_2"), cat_cols = "some_factor", num_cols = "some_var", id_cols = "some_id", summarize_size = TRUE, include_normalized = 2, rank_weights = NULL, cat_levels_rank_weights = NULL, num_normalize_fn = function(x) {
      rearrr::min_max_scale(x, old_min = quantile(x, 0.025), old_max = quantile(x,
          0.975), new_min = 0, new_max = 1)
  }), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18360[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'include_normalized': Must be of type 'logical flag', not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18360[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing check_summarize_balances_(data = df, group_c...
  # Changed from baseline: include_normalized = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17375 <- xpectr::capture_side_effects(check_summarize_balances_(data = df, group_cols = c("grp_1", "grp_2"), cat_cols = "some_factor", num_cols = "some_var", id_cols = "some_id", summarize_size = TRUE, include_normalized = NA, rank_weights = NULL, cat_levels_rank_weights = NULL, num_normalize_fn = function(x) {
      rearrr::min_max_scale(x, old_min = quantile(x, 0.025), old_max = quantile(x,
          0.975), new_min = 0, new_max = 1)
  }), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17375[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'include_normalized': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17375[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing check_summarize_balances_(data = df, group_c...
  # Changed from baseline: include_normalized = ...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18110 <- xpectr::capture_side_effects(check_summarize_balances_(data = df, group_cols = c("grp_1", "grp_2"), cat_cols = "some_factor", num_cols = "some_var", id_cols = "some_id", summarize_size = TRUE, include_normalized = NULL, rank_weights = NULL, cat_levels_rank_weights = NULL, num_normalize_fn = function(x) {
      rearrr::min_max_scale(x, old_min = quantile(x, 0.025), old_max = quantile(x,
          0.975), new_min = 0, new_max = 1)
  }), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18110[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'include_normalized': Must be of type 'logical flag', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18110[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing check_summarize_balances_(data = df, group_c...
  # Changed from baseline: rank_weights = c(s...
  xpectr::set_test_seed(42)
  # Testing is NULL
  expect_true(
    is.null(check_summarize_balances_(data = df, group_cols = c("grp_1", "grp_2"), cat_cols = "some_factor", num_cols = "some_var", id_cols = "some_id", summarize_size = TRUE, include_normalized = FALSE, rank_weights = c(size = 2), cat_levels_rank_weights = NULL, num_normalize_fn = function(x) {
      rearrr::min_max_scale(x, old_min = quantile(x, 0.025), old_max = quantile(x,
          0.975), new_min = 0, new_max = 1)
  })))

  # Testing check_summarize_balances_(data = df, group_c...
  # Changed from baseline: rank_weights = c(s...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16851 <- xpectr::capture_side_effects(check_summarize_balances_(data = df, group_cols = c("grp_1", "grp_2"), cat_cols = "some_factor", num_cols = "some_var", id_cols = "some_id", summarize_size = TRUE, include_normalized = FALSE, rank_weights = c(size = NA), cat_levels_rank_weights = NULL, num_normalize_fn = function(x) {
      rearrr::min_max_scale(x, old_min = quantile(x, 0.025), old_max = quantile(x,
          0.975), new_min = 0, new_max = 1)
  }), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16851[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'rank_weights': Contains missing values (element 1)."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16851[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing check_summarize_balances_(data = df, group_c...
  # Changed from baseline: rank_weights = 2
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_10039 <- xpectr::capture_side_effects(check_summarize_balances_(data = df, group_cols = c("grp_1", "grp_2"), cat_cols = "some_factor", num_cols = "some_var", id_cols = "some_id", summarize_size = TRUE, include_normalized = FALSE, rank_weights = 2, cat_levels_rank_weights = NULL, num_normalize_fn = function(x) {
      rearrr::min_max_scale(x, old_min = quantile(x, 0.025), old_max = quantile(x,
          0.975), new_min = 0, new_max = 1)
  }), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10039[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'rank_weights': Must have names."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10039[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing check_summarize_balances_(data = df, group_c...
  # Changed from baseline: rank_weights = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18329 <- xpectr::capture_side_effects(check_summarize_balances_(data = df, group_cols = c("grp_1", "grp_2"), cat_cols = "some_factor", num_cols = "some_var", id_cols = "some_id", summarize_size = TRUE, include_normalized = FALSE, rank_weights = NA, cat_levels_rank_weights = NULL, num_normalize_fn = function(x) {
      rearrr::min_max_scale(x, old_min = quantile(x, 0.025), old_max = quantile(x,
          0.975), new_min = 0, new_max = 1)
  }), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18329[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'rank_weights': Must have names."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18329[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing check_summarize_balances_(data = df, group_c...
  # Changed from baseline: num_normalize_fn = st...
  xpectr::set_test_seed(42)
  # Testing is NULL
  expect_true(
    is.null(check_summarize_balances_(data = df, group_cols = c("grp_1", "grp_2"), cat_cols = "some_factor", num_cols = "some_var", id_cols = "some_id", summarize_size = TRUE, include_normalized = FALSE, rank_weights = NULL, cat_levels_rank_weights = NULL, num_normalize_fn = standardize_)))

  # Testing check_summarize_balances_(data = df, group_c...
  # Changed from baseline: num_normalize_fn = 2
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12076 <- xpectr::capture_side_effects(check_summarize_balances_(data = df, group_cols = c("grp_1", "grp_2"), cat_cols = "some_factor", num_cols = "some_var", id_cols = "some_id", summarize_size = TRUE, include_normalized = FALSE, rank_weights = NULL, cat_levels_rank_weights = NULL, num_normalize_fn = 2), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12076[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'num_normalize_fn': Must be a function, not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12076[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing check_summarize_balances_(data = df, group_c...
  # Changed from baseline: num_normalize_fn = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19066 <- xpectr::capture_side_effects(check_summarize_balances_(data = df, group_cols = c("grp_1", "grp_2"), cat_cols = "some_factor", num_cols = "some_var", id_cols = "some_id", summarize_size = TRUE, include_normalized = FALSE, rank_weights = NULL, cat_levels_rank_weights = NULL, num_normalize_fn = NA), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19066[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'num_normalize_fn': Must be a function, not 'logical'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19066[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing check_summarize_balances_(data = df, group_c...
  # Changed from baseline: num_normalize_fn = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16117 <- xpectr::capture_side_effects(check_summarize_balances_(data = df, group_cols = c("grp_1", "grp_2"), cat_cols = "some_factor", num_cols = "some_var", id_cols = "some_id", summarize_size = TRUE, include_normalized = FALSE, rank_weights = NULL, cat_levels_rank_weights = NULL, num_normalize_fn = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16117[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'num_normalize_fn': Must be a function, not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16117[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  ## Finished testing 'check_summarize_balances_'                             ####
  #

})

test_that("testing summarize_balances()", {

  xpectr::set_test_seed(42)

  # Regression tests

  # The dataset from the example
  df <- data.frame(
    "some_var" = runif(25),
    "some_factor" = factor(sample(1:3, size = 25, replace=TRUE)),
    "some_id" = factor(sample(1:7, size = 25, replace=TRUE)),
    "grp_1" = factor(sample(1:5, size = 25, replace=TRUE)),
    "grp_2" = factor(sample(1:8, size = 25, replace=TRUE)),
    "grp_3" = factor(sample(LETTERS[1:3], size = 25, replace=TRUE)),
    "grp_4" = factor(sample(LETTERS[1:12], size = 25, replace=TRUE))
  )

  summ <- summarize_balances(
    data = df,
    group_cols = paste0('grp_', 1:4),
    num_cols = "some_var",
    cat_cols = "some_factor",
    id_cols = "some_id",
    include_normalized = TRUE
  )

  # Test correct number of group column members
  members <- table(summ$Groups[[".group_col"]])
  expect_equal(members[["grp_1"]], nlevels(df$grp_1))
  expect_equal(members[["grp_2"]], nlevels(df$grp_2))
  expect_equal(members[["grp_3"]], nlevels(df$grp_3))
  expect_equal(members[["grp_4"]], nlevels(df$grp_4))

  ## Testing 'summ$Groups'                                                  ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(summ$Groups),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    summ$Groups[[".group_col"]],
    structure(c(1L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
      3L, 3L, 3L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L), .Label = c("grp_1",
      "grp_2", "grp_3", "grp_4"), class = "factor"))
  expect_equal(
    summ$Groups[[".group"]],
    structure(c(1L, 2L, 3L, 4L, 5L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L,
      9L, 10L, 11L, 9L, 10L, 11L, 12L, 13L, 14L, 15L, 16L, 17L, 18L,
      19L), .Label = c("1", "2", "3", "4", "5", "6", "7", "8", "A",
      "B", "C", "D", "E", "F", "G", "H", "I", "J", "L"), class = "factor"))
  expect_equal(
    summ$Groups[["# rows"]],
    c(6, 6, 4, 7, 2, 2, 2, 2, 3, 7, 4, 3, 2, 7, 6, 12, 1, 2, 4, 2, 3,
      3, 2, 1, 4, 2, 1),
    tolerance = 1e-4)
  expect_equal(
    summ$Groups[["# some_id"]],
    c(6, 5, 3, 4, 2, 2, 1, 2, 3, 4, 3, 3, 2, 4, 4, 7, 1, 2, 3, 2, 3,
      2, 2, 1, 3, 2, 1),
    tolerance = 1e-4)
  expect_equal(
    summ$Groups[["mean(some_var)"]],
    c(0.74729, 0.30973, 0.69904, 0.73572, 0.51766, 0.84165, 0.61161,
      0.51076, 0.4082, 0.70394, 0.46712, 0.73804, 0.58042, 0.69303,
      0.4706, 0.63741, 0.13467, 0.56599, 0.62309, 0.52728, 0.65268,
      0.66911, 0.5907, 0.93467, 0.79141, 0.40262, 0.45774),
    tolerance = 1e-4)
  expect_equal(
    summ$Groups[["sum(some_var)"]],
    c(4.48374, 1.85841, 2.79618, 5.15001, 1.03533, 1.68329, 1.22321,
      1.02152, 1.22459, 4.9276, 1.8685, 2.21412, 1.16084, 4.85118,
      2.82358, 7.64891, 0.13467, 1.13199, 2.49236, 1.05456, 1.95805,
      2.00733, 1.18141, 0.93467, 3.16565, 0.80524, 0.45774),
    tolerance = 1e-4)
  expect_equal(
    summ$Groups[["# some_1"]],
    c(1, 2, 0, 1, 0, 1, 0, 1, 0, 0, 0, 2, 0, 1, 1, 2, 0, 0, 0, 1, 0,
      0, 1, 1, 1, 0, 0),
    tolerance = 1e-4)
  expect_equal(
    summ$Groups[["# some_2"]],
    c(2, 2, 2, 3, 1, 1, 1, 0, 1, 3, 3, 1, 0, 4, 3, 3, 1, 0, 2, 1, 2,
      2, 1, 0, 1, 0, 0),
    tolerance = 1e-4)
  expect_equal(
    summ$Groups[["# some_3"]],
    c(3, 2, 2, 3, 1, 0, 1, 1, 2, 4, 1, 0, 2, 2, 2, 7, 0, 2, 2, 0, 1,
      1, 0, 0, 2, 2, 1),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(summ$Groups),
    c(".group_col", ".group", "# rows", "# some_id", "mean(some_var)",
      "sum(some_var)", "# some_1", "# some_2", "# some_3"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(summ$Groups),
    c("factor", "factor", "integer", "integer", "numeric", "numeric",
      "numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(summ$Groups),
    c("integer", "integer", "integer", "integer", "double", "double",
      "double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(summ$Groups),
    c(27L, 9L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(summ$Groups)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'summ$Groups'                                         ####



  ## Testing 'summ$Summary'                                                 ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(summ$Summary),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    summ$Summary[[".group_col"]],
    structure(c(1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 3L,
      3L, 3L, 3L, 3L, 3L, 4L, 4L, 4L, 4L, 4L, 4L), .Label = c("grp_1",
      "grp_2", "grp_3", "grp_4"), class = "factor"))
  expect_equal(
    summ$Summary[["measure"]],
    c("mean", "median", "SD", "IQR", "min", "max", "mean", "median",
      "SD", "IQR", "min", "max", "mean", "median", "SD", "IQR", "min",
      "max", "mean", "median", "SD", "IQR", "min", "max"),
    fixed = TRUE)
  expect_equal(
    summ$Summary[["# rows"]],
    c(5, 6, 2, 2, 2, 7, 3.125, 2.5, 1.72689, 1.25, 2, 7, 8.33333, 7,
      3.21455, 3, 6, 12, 2.27273, 2, 1.10371, 1.5, 1, 4),
    tolerance = 1e-4)
  expect_equal(
    summ$Summary[["# some_id"]],
    c(4, 4, 1.58114, 2, 2, 6, 2.5, 2.5, 0.92582, 1, 1, 4, 5, 4, 1.73205,
      1.5, 4, 7, 2, 2, 0.7746, 1, 1, 3),
    tolerance = 1e-4)
  expect_equal(
    summ$Summary[["mean(some_var)"]],
    c(0.60189, 0.69904, 0.18771, 0.21805, 0.30973, 0.74729, 0.60772,
      0.59601, 0.14673, 0.21262, 0.4082, 0.84165, 0.60034, 0.63741,
      0.11575, 0.11121, 0.4706, 0.69303, 0.57727, 0.5907, 0.20816,
      0.16839, 0.13467, 0.93467),
    tolerance = 1e-4)
  expect_equal(
    summ$Summary[["sum(some_var)"]],
    c(3.06473, 2.79618, 1.73261, 2.62533, 1.03533, 5.15001, 1.91546,
      1.45394, 1.28415, 0.74728, 1.02152, 4.9276, 5.10789, 4.85118,
      2.42288, 2.41266, 2.82358, 7.64891, 1.39306, 1.13199, 0.91042,
      1.11274, 0.13467, 3.16565),
    tolerance = 1e-4)
  expect_equal(
    summ$Summary[["# some_1"]],
    c(0.8, 1, 0.83666, 1, 0, 2, 0.5, 0, 0.75593, 1, 0, 2, 1.33333, 1,
      0.57735, 0.5, 1, 2, 0.36364, 0, 0.50452, 1, 0, 1),
    tolerance = 1e-4)
  expect_equal(
    summ$Summary[["# some_2"]],
    c(2, 2, 0.70711, 0, 1, 3, 1.25, 1, 1.16496, 0.75, 0, 3, 3.33333,
      3, 0.57735, 0.5, 3, 4, 0.90909, 1, 0.83121, 1.5, 0, 2),
    tolerance = 1e-4)
  expect_equal(
    summ$Summary[["# some_3"]],
    c(2.2, 2, 0.83666, 1, 1, 3, 1.375, 1, 1.30247, 1.25, 0, 4, 3.66667,
      2, 2.88675, 2.5, 2, 7, 1, 1, 0.89443, 2, 0, 2),
    tolerance = 1e-4)
  expect_equal(
    summ$Summary[["some_SD_rank"]],
    c(2.33333, 2.33333, 2.33333, 2.33333,
    2.33333, 2.33333, 3.33333, 3.33333,
    3.33333, 3.33333, 3.33333, 3.33333,
    2.33333, 2.33333, 2.33333, 2.33333,
    2.33333, 2.33333, 2, 2, 2, 2, 2, 2),
    tolerance = 1e-4)
  expect_equal(
    summ$Summary[["some_v_SD_rank"]],
    c(3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2.5, 2.5, 2.5, 2.5, 2.5,
    2.5, 2.5, 2.5, 2.5, 2.5, 2.5, 2.5),
    tolerance = 1e-4)
  expect_equal(
    summ$Summary[["SD_rank"]],
    c(2.83333, 2.833333, 2.833333, 2.833333,
    2.833333, 2.83333, 2.33333, 2.33333,
    2.33333, 2.33333, 2.33333, 2.33333,
    3.20833, 3.20833, 3.20833, 3.20833,
    3.20833, 3.20833, 1.625, 1.625, 1.625, 1.625,
    1.625, 1.625),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(summ$Summary),
    c(".group_col", "measure", "# rows", "# some_id", "mean(some_var)",
      "sum(some_var)", "# some_1", "# some_2", "# some_3", "some_SD_rank",
      "some_v_SD_rank", "SD_rank"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(summ$Summary),
    c("factor", "character", "numeric", "numeric", "numeric", "numeric",
      "numeric", "numeric", "numeric", "numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(summ$Summary),
    c("integer", "character", "double", "double", "double", "double",
      "double", "double", "double", "double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(summ$Summary),
    c(24L, 12L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(summ$Summary)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'summ$Summary'                                        ####



  ## Testing 'summ$`Normalized Summary`'                                    ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(summ$`Normalized Summary`),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    summ$`Normalized Summary`[[".group_col"]],
    structure(c(1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 3L,
      3L, 3L, 3L, 3L, 3L, 4L, 4L, 4L, 4L, 4L, 4L), .Label = c("grp_1",
      "grp_2", "grp_3", "grp_4"), class = "factor"))
  expect_equal(
    summ$`Normalized Summary`[["measure"]],
    c("mean", "median", "SD", "IQR", "min", "max", "mean", "median",
      "SD", "IQR", "min", "max", "mean", "median", "SD", "IQR", "min",
      "max", "mean", "median", "SD", "IQR", "min", "max"),
    fixed = TRUE)
  expect_equal(
    summ$`Normalized Summary`[["log(# rows)"]],
    c(0.75388, 0.8451, 0.17213, 0.14613, 0.47712, 0.90309, 0.58933,
      0.53959, 0.15173, 0.14917, 0.47712, 0.90309, 0.95404, 0.90309,
      0.14148, 0.13442, 0.8451, 1.11394, 0.49215, 0.47712, 0.14839,
      0.21298, 0.30103, 0.69897),
    tolerance = 1e-4)
  expect_equal(
    summ$`Normalized Summary`[["log(# some_id)"]],
    c(0.68028, 0.69897, 0.14533, 0.17609, 0.47712, 0.8451, 0.52969,
      0.53959, 0.12244, 0.12494, 0.30103, 0.69897, 0.76701, 0.69897,
      0.11785, 0.10206, 0.69897, 0.90309, 0.46317, 0.47712, 0.11735,
      0.15051, 0.30103, 0.60206),
    tolerance = 1e-4)
  expect_equal(
    summ$`Normalized Summary`[["mean(some_var)"]],
    c(0.56702, 0.67754, 0.21354, 0.24806, 0.23465, 0.73243, 0.57365,
      0.56033, 0.16692, 0.24188, 0.34667, 0.83977, 0.56526, 0.60742,
      0.13168, 0.12652, 0.41766, 0.6707, 0.53901, 0.55429, 0.23681,
      0.19156, 0.03549, 0.9456),
    tolerance = 1e-4)
  expect_equal(
    summ$`Normalized Summary`[["sum(some_var)"]],
    c(2.89798, 2.71017, 1.79483, 2.98664, 0.9424, 5.03483, 1.81124,
      1.40548, 1.27196, 0.72719, 0.92669, 4.7818, 4.82996, 4.69487,
      2.39444, 2.39158, 2.50593, 7.2891, 1.31726, 1.05236, 0.91277,
      1.08932, 0.03549, 3.13049),
    tolerance = 1e-4)
  expect_equal(
    summ$`Normalized Summary`[["log(# some_1)"]],
    c(0.21584, 0.30103, 0.20974, 0.30103, 0, 0.47712, 0.1349, 0, 0.19395,
      0.30103, 0, 0.47712, 0.35973, 0.30103, 0.10167, 0.08805, 0.30103,
      0.47712, 0.10947, 0, 0.15188, 0.30103, 0, 0.30103),
    tolerance = 1e-4)
  expect_equal(
    summ$`Normalized Summary`[["log(# some_2)"]],
    c(0.46689, 0.47712, 0.10735, 0, 0.30103, 0.60206, 0.30103, 0.30103,
      0.22756, 0.15051, 0, 0.60206, 0.63436, 0.60206, 0.05595, 0.04846,
      0.60206, 0.69897, 0.23959, 0.30103, 0.20346, 0.38908, 0, 0.47712),
    tolerance = 1e-4)
  expect_equal(
    summ$`Normalized Summary`[["log(# some_3)"]],
    c(0.49188, 0.47712, 0.12363, 0.12494, 0.30103, 0.60206, 0.31954,
      0.30103, 0.23871, 0.25135, 0, 0.69897, 0.61911, 0.47712, 0.24593,
      0.21298, 0.47712, 0.90309, 0.2556, 0.30103, 0.21536, 0.47712,
      0, 0.47712),
    tolerance = 1e-4)
  expect_equal(
    summ$`Normalized Summary`[["some_SD_rank"]], # TODO Perhaps cat_max_prefix_chars should also depend on num_cols??
    c(2.33333, 2.33333, 2.33333, 2.33333,
    2.33333, 2.33333, 3.33333, 3.33333,
    3.33333, 3.33333, 3.33333, 3.33333,
    2, 2, 2, 2, 2, 2, 2.33333, 2.33333, 2.33333,
    2.33333, 2.33333, 2.33333),
    tolerance = 1e-4)
  expect_equal(
    summ$`Normalized Summary`[["some_v_SD_rank"]],
    c(3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2.5, 2.5, 2.5, 2.5, 2.5,
    2.5, 2.5, 2.5, 2.5, 2.5, 2.5, 2.5),
    tolerance = 1e-4)
  expect_equal(
    summ$`Normalized Summary`[["SD_rank"]],
    c(3.33333, 3.33333, 3.33333, 3.33333,
    3.33333, 3.33333, 2.83333, 2.83333,
    2.83333, 2.83333, 2.83333, 2.83333,
    1.875, 1.875, 1.875, 1.875, 1.875, 1.875, 1.95833, 1.95833,
    1.95833, 1.95833, 1.95833, 1.95833
    ),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(summ$`Normalized Summary`),
    c(".group_col", "measure", "log(# rows)", "log(# some_id)", "mean(some_var)",
      "sum(some_var)", "log(# some_1)", "log(# some_2)", "log(# some_3)",
      "some_SD_rank", "some_v_SD_rank", "SD_rank"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(summ$`Normalized Summary`),
    c("factor", "character", "numeric", "numeric", "numeric", "numeric",
      "numeric", "numeric", "numeric", "numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(summ$`Normalized Summary`),
    c("integer", "character", "double", "double", "double", "double",
      "double", "double", "double", "double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(summ$`Normalized Summary`),
    c(24L, 12L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(summ$`Normalized Summary`)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'summ$`Normalized Summary`'                           ####


  ## Testing 'summ %>% ranked_balances()'                                   ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- summ %>% ranked_balances()
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[[".group_col"]],
    structure(c(4L, 2L, 1L, 3L), .Label = c("grp_1", "grp_2", "grp_3",
      "grp_4"), class = "factor"))
  expect_equal(
    output_19148[["measure"]],
    c("SD", "SD", "SD", "SD"),
    fixed = TRUE)
  expect_equal(
    output_19148[["# rows"]],
    c(1.10371, 1.72689, 2, 3.21455),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["# some_id"]],
    c(0.7746, 0.92582, 1.58114, 1.73205),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["mean(some_var)"]],
    c(0.20816, 0.14673, 0.18771, 0.11575),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["sum(some_var)"]],
    c(0.91042, 1.28415, 1.73261, 2.42288),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["# some_1"]],
    c(0.50452, 0.75593, 0.83666, 0.57735),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["# some_2"]],
    c(0.83121, 1.16496, 0.70711, 0.57735),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["# some_3"]],
    c(0.89443, 1.30247, 0.83666, 2.88675),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["some_SD_rank"]],
    c(2, 3.33333, 2.33333, 2.33333),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["some_v_SD_rank"]],
    c(2.5, 2, 3, 2.5),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["SD_rank"]],
    c(1.625, 2.33333, 2.83333, 3.20833),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19148),
    c(".group_col", "measure", "# rows", "# some_id", "mean(some_var)",
      "sum(some_var)", "# some_1", "# some_2", "# some_3", "some_SD_rank",
      "some_v_SD_rank", "SD_rank"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("factor", "character", "numeric", "numeric", "numeric", "numeric",
      "numeric", "numeric", "numeric", "numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("integer", "character", "double", "double", "double", "double",
      "double", "double", "double", "double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(4L, 12L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'summ %>% ranked_balances()'                          ####


})

test_that("testing examples for summarize_balances()", {

  # Regression tests

  xpectr::set_test_seed(1)

  # Create data frame
  df <- data.frame(
    "participant" = factor(rep(c("1", "2", "3", "4", "5", "6"), 3)),
    "age" = rep(sample(c(1:100), 6), 3),
    "diagnosis" = factor(rep(c("a", "b", "a", "a", "b", "b"), 3)),
    "score" = sample(c(1:100), 3 * 6)
  )
  df <- df %>% dplyr::arrange(participant)
  df$session <- rep(c("1", "2", "3"), 6)

  # Using fold()

  ## Without balancing
  xpectr::set_test_seed(1)
  df_folded <- fold(data = df, k = 3)

  # Check the balances of the various columns
  # As we have not used balancing in `fold()`
  # we should not expect it to be amazingly balanced
  summ <- df_folded %>%
    dplyr::ungroup() %>%
    summarize_balances(
      group_cols = ".folds",
      num_cols = c("score", "age"),
      cat_cols = "diagnosis",
      id_cols="participant",
      include_normalized = TRUE
    )

  expect_equal(names(summ),
               c("Groups", "Summary", "Normalized Summary"),
               fixed = TRUE)


  ## Testing 'summ$Groups'                                                  ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(summ$Groups),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    summ$Groups[[".group_col"]],
    structure(c(1L, 1L, 1L), .Label = ".folds", class = "factor"))
  expect_equal(
    summ$Groups[[".group"]],
    structure(1:3, .Label = c("1", "2", "3"), class = "factor"))
  expect_equal(
    summ$Groups[["# rows"]],
    c(6, 6, 6),
    tolerance = 1e-4)
  expect_equal(
    summ$Groups[["# participant"]],
    c(5, 5, 4),
    tolerance = 1e-4)
  expect_equal(
    summ$Groups[["mean(score)"]],
    c(42.5, 44.66667, 68.66667),
    tolerance = 1e-4)
  expect_equal(
    summ$Groups[["sum(score)"]],
    c(255, 268, 412),
    tolerance = 1e-4)
  expect_equal(
    summ$Groups[["mean(age)"]],
    c(58, 53.83333, 46.16667),
    tolerance = 1e-4)
  expect_equal(
    summ$Groups[["sum(age)"]],
    c(348, 323, 277),
    tolerance = 1e-4)
  expect_equal(
    summ$Groups[["# diag_a"]],
    c(3, 4, 2),
    tolerance = 1e-4)
  expect_equal(
    summ$Groups[["# diag_b"]],
    c(3, 2, 4),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(summ$Groups),
    c(".group_col", ".group", "# rows", "# participant", "mean(score)",
      "sum(score)", "mean(age)", "sum(age)", "# diag_a", "# diag_b"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(summ$Groups),
    c("factor", "factor", "integer", "integer", "numeric", "integer",
      "numeric", "integer", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(summ$Groups),
    c("integer", "integer", "integer", "integer", "double", "integer",
      "double", "integer", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(summ$Groups),
    c(3L, 10L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(summ$Groups)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'summ$Groups'                                         ####


  ## Testing 'summ$Summary'                                                 ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(summ$Summary),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    summ$Summary[[".group_col"]],
    structure(c(1L, 1L, 1L, 1L, 1L, 1L), .Label = ".folds", class = "factor"))
  expect_equal(
    summ$Summary[["measure"]],
    c("mean", "median", "SD", "IQR", "min", "max"),
    fixed = TRUE)
  expect_equal(
    summ$Summary[["# rows"]],
    c(6, 6, 0, 0, 6, 6),
    tolerance = 1e-4)
  expect_equal(
    summ$Summary[["# participant"]],
    c(4.66667, 5, 0.57735, 0.5, 4, 5),
    tolerance = 1e-4)
  expect_equal(
    summ$Summary[["mean(score)"]],
    c(51.94444, 44.66667, 14.52233, 13.08333, 42.5, 68.66667),
    tolerance = 1e-4)
  expect_equal(
    summ$Summary[["sum(score)"]],
    c(311.66667, 268, 87.134, 78.5, 255, 412),
    tolerance = 1e-4)
  expect_equal(
    summ$Summary[["mean(age)"]],
    c(52.66667, 53.83333, 6.00231, 5.91667, 46.16667, 58),
    tolerance = 1e-4)
  expect_equal(
    summ$Summary[["sum(age)"]],
    c(316, 323, 36.01389, 35.5, 277, 348),
    tolerance = 1e-4)
  expect_equal(
    summ$Summary[["# diag_a"]],
    c(3, 3, 1, 1, 2, 4),
    tolerance = 1e-4)
  expect_equal(
    summ$Summary[["# diag_b"]],
    c(3, 3, 1, 1, 2, 4),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(summ$Summary),
    c(".group_col", "measure", "# rows", "# participant", "mean(score)",
      "sum(score)", "mean(age)", "sum(age)", "# diag_a", "# diag_b"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(summ$Summary),
    c("factor", "character", "numeric", "numeric", "numeric", "numeric",
      "numeric", "numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(summ$Summary),
    c("integer", "character", "double", "double", "double", "double",
      "double", "double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(summ$Summary),
    c(6L, 10L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(summ$Summary)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'summ$Summary'                                        ####


  ## Testing 'summ$`Normalized Summary`'                                    ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(summ$`Normalized Summary`),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    summ$`Normalized Summary`[[".group_col"]],
    structure(c(1L, 1L, 1L, 1L, 1L, 1L), .Label = ".folds", class = "factor"))
  expect_equal(
    summ$`Normalized Summary`[["measure"]],
    c("mean", "median", "SD", "IQR", "min", "max"),
    fixed = TRUE)
  expect_equal(
    summ$`Normalized Summary`[["log(# rows)"]],
    c(0.8451, 0.8451, 0, 0, 0.8451, 0.8451),
    tolerance = 1e-4)
  expect_equal(
    summ$`Normalized Summary`[["log(# participant)"]],
    c(0.75176, 0.77815, 0.04572, 0.03959, 0.69897, 0.77815),
    tolerance = 1e-4)
  expect_equal(
    summ$`Normalized Summary`[["mean(norm(score))"]],
    c(0.50688, 0.42269, 0.16799, 0.15134, 0.39763, 0.70031),
    tolerance = 1e-4)
  expect_equal(
    summ$`Normalized Summary`[["sum(norm(score))"]],
    c(3.04126, 2.53615, 1.00791, 0.90804, 2.38577, 4.20185),
    tolerance = 1e-4)
  expect_equal(
    summ$`Normalized Summary`[["mean(norm(age))"]],
    c(0.47343, 0.49034, 0.08699, 0.08575, 0.37923, 0.55072),
    tolerance = 1e-4)
  expect_equal(
    summ$`Normalized Summary`[["sum(norm(age))"]],
    c(2.84058, 2.94203, 0.52194, 0.51449, 2.27536, 3.30435),
    tolerance = 1e-4)
  expect_equal(
    summ$`Normalized Summary`[["log(# diag_a)"]],
    c(0.59272, 0.60206, 0.11122, 0.11092, 0.47712, 0.69897),
    tolerance = 1e-4)
  expect_equal(
    summ$`Normalized Summary`[["log(# diag_b)"]],
    c(0.59272, 0.60206, 0.11122, 0.11092, 0.47712, 0.69897),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(summ$`Normalized Summary`),
    c(".group_col", "measure", "log(# rows)", "log(# participant)",
      "mean(norm(score))", "sum(norm(score))", "mean(norm(age))",
      "sum(norm(age))", "log(# diag_a)", "log(# diag_b)"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(summ$`Normalized Summary`),
    c("factor", "character", "numeric", "numeric", "numeric", "numeric",
      "numeric", "numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(summ$`Normalized Summary`),
    c("integer", "character", "double", "double", "double", "double",
      "double", "double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(summ$`Normalized Summary`),
    c(6L, 10L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(summ$`Normalized Summary`)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'summ$`Normalized Summary`'                           ####


  ## Testing 'summ %>% ranked_balances()'                                   ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_13800 <- summ %>% ranked_balances()
  # Testing class
  expect_equal(
    class(output_13800),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_13800[[".group_col"]],
    structure(1L, .Label = ".folds", class = "factor"))
  expect_equal(
    output_13800[["measure"]],
    "SD",
    fixed = TRUE)
  expect_equal(
    output_13800[["# rows"]],
    0,
    tolerance = 1e-4)
  expect_equal(
    output_13800[["# participant"]],
    0.57735,
    tolerance = 1e-4)
  expect_equal(
    output_13800[["mean(score)"]],
    14.52233,
    tolerance = 1e-4)
  expect_equal(
    output_13800[["sum(score)"]],
    87.134,
    tolerance = 1e-4)
  expect_equal(
    output_13800[["mean(age)"]],
    6.00231,
    tolerance = 1e-4)
  expect_equal(
    output_13800[["sum(age)"]],
    36.01389,
    tolerance = 1e-4)
  expect_equal(
    output_13800[["# diag_a"]],
    1,
    tolerance = 1e-4)
  expect_equal(
    output_13800[["# diag_b"]],
    1,
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_13800),
    c(".group_col", "measure", "# rows", "# participant", "mean(score)",
      "sum(score)", "mean(age)", "sum(age)", "# diag_a", "# diag_b"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_13800),
    c("factor", "character", "numeric", "numeric", "numeric", "numeric",
      "numeric", "numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_13800),
    c("integer", "character", "double", "double", "double", "double",
      "double", "double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_13800),
    c(1L, 10L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_13800)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'summ %>% ranked_balances()'                          ####


  ## With balancing
  xpectr::set_test_seed(1)
  df_folded <- fold(
    data = df,
    k = 3,
    cat_col = "diagnosis",
    num_col = 'score',
    id_col = 'participant'
  )

  # Now the balance should be better
  # although it may be difficult to get a good balance
  # the 'score' column when also balancing on 'diagnosis'
  # and keeping all rows per participant in the same fold
  summ <- df_folded %>%
    dplyr::ungroup() %>%
    summarize_balances(
      group_cols = ".folds",
      num_cols = c("score", "age"),
      cat_cols = "diagnosis",
      id_cols="participant",
      include_normalized = FALSE
    )

  expect_equal(names(summ),
               c("Groups", "Summary"),
               fixed = TRUE)


  ## Testing 'summ$Groups'                                                  ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(summ$Groups),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    summ$Groups[[".group_col"]],
    structure(c(1L, 1L, 1L), .Label = ".folds", class = "factor"))
  expect_equal(
    summ$Groups[[".group"]],
    structure(1:3, .Label = c("1", "2", "3"), class = "factor"))
  expect_equal(
    summ$Groups[["# rows"]],
    c(6, 6, 6),
    tolerance = 1e-4)
  expect_equal(
    summ$Groups[["# participant"]],
    c(2, 2, 2),
    tolerance = 1e-4)
  expect_equal(
    summ$Groups[["mean(score)"]],
    c(40.16667, 60.5, 55.16667),
    tolerance = 1e-4)
  expect_equal(
    summ$Groups[["sum(score)"]],
    c(241, 363, 331),
    tolerance = 1e-4)
  expect_equal(
    summ$Groups[["mean(age)"]],
    c(63, 23.5, 71.5),
    tolerance = 1e-4)
  expect_equal(
    summ$Groups[["sum(age)"]],
    c(378, 141, 429),
    tolerance = 1e-4)
  expect_equal(
    summ$Groups[["# diag_a"]],
    c(3, 3, 3),
    tolerance = 1e-4)
  expect_equal(
    summ$Groups[["# diag_b"]],
    c(3, 3, 3),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(summ$Groups),
    c(".group_col", ".group", "# rows", "# participant", "mean(score)",
      "sum(score)", "mean(age)", "sum(age)", "# diag_a", "# diag_b"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(summ$Groups),
    c("factor", "factor", "integer", "integer", "numeric", "integer",
      "numeric", "integer", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(summ$Groups),
    c("integer", "integer", "integer", "integer", "double", "integer",
      "double", "integer", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(summ$Groups),
    c(3L, 10L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(summ$Groups)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'summ$Groups'                                         ####


  ## Testing 'summ$Summary'                                                 ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(summ$Summary),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    summ$Summary[[".group_col"]],
    structure(c(1L, 1L, 1L, 1L, 1L, 1L), .Label = ".folds", class = "factor"))
  expect_equal(
    summ$Summary[["measure"]],
    c("mean", "median", "SD", "IQR", "min", "max"),
    fixed = TRUE)
  expect_equal(
    summ$Summary[["# rows"]],
    c(6, 6, 0, 0, 6, 6),
    tolerance = 1e-4)
  expect_equal(
    summ$Summary[["# participant"]],
    c(2, 2, 0, 0, 2, 2),
    tolerance = 1e-4)
  expect_equal(
    summ$Summary[["mean(score)"]],
    c(51.94444, 55.16667, 10.54268, 10.16667, 40.16667, 60.5),
    tolerance = 1e-4)
  expect_equal(
    summ$Summary[["sum(score)"]],
    c(311.66667, 331, 63.25609, 61, 241, 363),
    tolerance = 1e-4)
  expect_equal(
    summ$Summary[["mean(age)"]],
    c(52.66667, 63, 25.61412, 24, 23.5, 71.5),
    tolerance = 1e-4)
  expect_equal(
    summ$Summary[["sum(age)"]],
    c(316, 378, 153.68474, 144, 141, 429),
    tolerance = 1e-4)
  expect_equal(
    summ$Summary[["# diag_a"]],
    c(3, 3, 0, 0, 3, 3),
    tolerance = 1e-4)
  expect_equal(
    summ$Summary[["# diag_b"]],
    c(3, 3, 0, 0, 3, 3),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(summ$Summary),
    c(".group_col", "measure", "# rows", "# participant", "mean(score)",
      "sum(score)", "mean(age)", "sum(age)", "# diag_a", "# diag_b"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(summ$Summary),
    c("factor", "character", "numeric", "numeric", "numeric", "numeric",
      "numeric", "numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(summ$Summary),
    c("integer", "character", "double", "double", "double", "double",
      "double", "double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(summ$Summary),
    c(6L, 10L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(summ$Summary)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'summ$Summary'                                        ####


  ## Testing 'summ %>% ranked_balances()'                                   ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- summ %>% ranked_balances()
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[[".group_col"]],
    structure(1L, .Label = ".folds", class = "factor"))
  expect_equal(
    output_19148[["measure"]],
    "SD",
    fixed = TRUE)
  expect_equal(
    output_19148[["# rows"]],
    0,
    tolerance = 1e-4)
  expect_equal(
    output_19148[["# participant"]],
    0,
    tolerance = 1e-4)
  expect_equal(
    output_19148[["mean(score)"]],
    10.54268,
    tolerance = 1e-4)
  expect_equal(
    output_19148[["sum(score)"]],
    63.25609,
    tolerance = 1e-4)
  expect_equal(
    output_19148[["mean(age)"]],
    25.61412,
    tolerance = 1e-4)
  expect_equal(
    output_19148[["sum(age)"]],
    153.68474,
    tolerance = 1e-4)
  expect_equal(
    output_19148[["# diag_a"]],
    0,
    tolerance = 1e-4)
  expect_equal(
    output_19148[["# diag_b"]],
    0,
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19148),
    c(".group_col", "measure", "# rows", "# participant", "mean(score)",
      "sum(score)", "mean(age)", "sum(age)", "# diag_a", "# diag_b"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("factor", "character", "numeric", "numeric", "numeric", "numeric",
      "numeric", "numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("integer", "character", "double", "double", "double", "double",
      "double", "double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(1L, 10L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'summ %>% ranked_balances()'                          ####



  # Comparing multiple grouping columns
  # Create 3 fold column that only balance "score"
  xpectr::set_test_seed(1)
  df_folded <- fold(
    data = df,
    k = 3,
    num_fold_cols = 3,
    num_col = 'score'
  )

  # Summarize all three grouping cols at once
  (summ <- df_folded %>%
      dplyr::ungroup() %>%
      summarize_balances(
        group_cols = paste0(".folds_", 1:3),
        num_cols = c("score")
      )
  )

  expect_equal(names(summ),
               c("Groups", "Summary"),
               fixed = TRUE)


  ## Testing 'summ$Groups'                                                  ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(summ$Groups),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    summ$Groups[[".group_col"]],
    structure(c(1L, 1L, 1L, 2L, 2L, 2L, 3L, 3L, 3L), .Label = c(".folds_1",
      ".folds_2", ".folds_3"), class = "factor"))
  expect_equal(
    summ$Groups[[".group"]],
    structure(c(1L, 2L, 3L, 1L, 2L, 3L, 1L, 2L, 3L), .Label = c("1",
      "2", "3"), class = "factor"))
  expect_equal(
    summ$Groups[["# rows"]],
    c(6, 6, 6, 6, 6, 6, 6, 6, 6),
    tolerance = 1e-4)
  expect_equal(
    summ$Groups[["mean(score)"]],
    c(51.5, 52.83333, 51.5, 52.16667, 52.16667, 51.5, 52.16667, 51.66667,
      52),
    tolerance = 1e-4)
  expect_equal(
    summ$Groups[["sum(score)"]],
    c(309, 317, 309, 313, 313, 309, 313, 310, 312),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(summ$Groups),
    c(".group_col", ".group", "# rows", "mean(score)", "sum(score)"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(summ$Groups),
    c("factor", "factor", "integer", "numeric", "integer"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(summ$Groups),
    c("integer", "integer", "integer", "double", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(summ$Groups),
    c(9L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(summ$Groups)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'summ$Groups'                                         ####


  ## Testing 'summ$Summary'                                                 ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(summ$Summary),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    summ$Summary[[".group_col"]],
    structure(c(1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 3L,
      3L, 3L, 3L, 3L, 3L), .Label = c(".folds_1", ".folds_2", ".folds_3"),
      class = "factor"))
  expect_equal(
    summ$Summary[["measure"]],
    c("mean", "median", "SD", "IQR", "min", "max", "mean", "median",
      "SD", "IQR", "min", "max", "mean", "median", "SD", "IQR", "min",
      "max"),
    fixed = TRUE)
  expect_equal(
    summ$Summary[["# rows"]],
    c(6, 6, 0, 0, 6, 6, 6, 6, 0, 0, 6, 6, 6, 6, 0, 0, 6, 6),
    tolerance = 1e-4)
  expect_equal(
    summ$Summary[["mean(score)"]],
    c(51.94444, 51.5, 0.7698, 0.66667, 51.5, 52.83333, 51.94444, 52.16667,
      0.3849, 0.33333, 51.5, 52.16667, 51.94444, 52, 0.25459, 0.25,
      51.66667, 52.16667),
    tolerance = 1e-4)
  expect_equal(
    summ$Summary[["sum(score)"]],
    c(311.66667, 309, 4.6188, 4, 309, 317, 311.66667, 313, 2.3094, 2,
      309, 313, 311.66667, 312, 1.52753, 1.5, 310, 313),
    tolerance = 1e-4)
  expect_equal(
    summ$Summary[["scor_SD_rank"]],
    c(3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1),
    tolerance = 1e-4)
  expect_equal(
    summ$Summary[["SD_rank"]],
    c(2.5, 2.5, 2.5, 2.5, 2.5, 2.5, 2, 2, 2, 2, 2, 2, 1.5, 1.5, 1.5,
      1.5, 1.5, 1.5),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(summ$Summary),
    c(".group_col", "measure", "# rows", "mean(score)", "sum(score)",
      "scor_SD_rank", "SD_rank"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(summ$Summary),
    c("factor", "character", "numeric", "numeric", "numeric", "numeric",
      "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(summ$Summary),
    c("integer", "character", "double", "double", "double", "double",
      "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(summ$Summary),
    c(18L, 7L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(summ$Summary)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'summ$Summary'                                        ####


  ## Testing 'summ %>% ranked_balances()'                                   ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- summ %>% ranked_balances()
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[[".group_col"]],
    structure(3:1, .Label = c(".folds_1", ".folds_2", ".folds_3"), class = "factor"))
  expect_equal(
    output_19148[["measure"]],
    c("SD", "SD", "SD"),
    fixed = TRUE)
  expect_equal(
    output_19148[["# rows"]],
    c(0, 0, 0),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["mean(score)"]],
    c(0.25459, 0.3849, 0.7698),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["sum(score)"]],
    c(1.52753, 2.3094, 4.6188),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["scor_SD_rank"]],
    c(1, 2, 3),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["SD_rank"]],
    c(1.5, 2, 2.5),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19148),
    c(".group_col", "measure", "# rows", "mean(score)", "sum(score)",
      "scor_SD_rank", "SD_rank"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("factor", "character", "numeric", "numeric", "numeric", "numeric",
      "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("integer", "character", "double", "double", "double", "double",
      "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(3L, 7L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'summ %>% ranked_balances()'                          ####


})

test_that("testing calculate_max_prefix_nchars_()", {
  xpectr::set_test_seed(42)

  # No overlap


  ## Testing 'calculate_max_prefix_nchars_( cat_cols = c("...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- calculate_max_prefix_nchars_(
    cat_cols = c("a", "b"),
    num_cols = c("c", "d")
  )
  # Testing class
  expect_equal(
    class(output_19148),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "list")
  # Testing values
  expect_equal(
    output_19148,
    list(max_cat_prefix_chars = 4L, max_num_prefix_chars = 4L))
  # Testing names
  expect_equal(
    names(output_19148),
    c("max_cat_prefix_chars", "max_num_prefix_chars"),
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    2L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    2L)
  ## Finished testing 'calculate_max_prefix_nchars_( cat_cols = c("...'     ####

  # Overlap but less than 4


  ## Testing 'calculate_max_prefix_nchars_( cat_cols = c("...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- calculate_max_prefix_nchars_(
    cat_cols = c("a", "ab"),
    num_cols = c("c", "cd")
  )
  # Testing class
  expect_equal(
    class(output_19148),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "list")
  # Testing values
  expect_equal(
    output_19148,
    list(max_cat_prefix_chars = 4L, max_num_prefix_chars = 4L))
  # Testing names
  expect_equal(
    names(output_19148),
    c("max_cat_prefix_chars", "max_num_prefix_chars"),
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    2L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    2L)
  ## Finished testing 'calculate_max_prefix_nchars_( cat_cols = c("...'     ####


  # Overlap with more than 4

  # num_cols are shorter names

  ## Testing 'calculate_max_prefix_nchars_( cat_cols = c("...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- calculate_max_prefix_nchars_(
    cat_cols = c("abcdefg_133", "abcdefg_233"),
    num_cols = c("hej_133", "hej_233")
  )
  # Testing class
  expect_equal(
    class(output_19148),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "list")
  # Testing values
  expect_equal(
    output_19148,
    list(max_cat_prefix_chars = 9L, max_num_prefix_chars = 9L))
  # Testing names
  expect_equal(
    names(output_19148),
    c("max_cat_prefix_chars", "max_num_prefix_chars"),
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    2L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    2L)
  ## Finished testing 'calculate_max_prefix_nchars_( cat_cols = c("...'     ####

  # cat_cols are shorter names

  ## Testing 'calculate_max_prefix_nchars_( cat_cols = c("...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- calculate_max_prefix_nchars_(
    cat_cols = c("hej_133", "hej_233"),
    num_cols = c("abcdefg_133", "abcdefg_233")
  )
  # Testing class
  expect_equal(
    class(output_19148),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "list")
  # Testing values
  expect_equal(
    output_19148,
    list(max_cat_prefix_chars = 5L, max_num_prefix_chars = 9L))
  # Testing names
  expect_equal(
    names(output_19148),
    c("max_cat_prefix_chars", "max_num_prefix_chars"),
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    2L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    2L)
  ## Finished testing 'calculate_max_prefix_nchars_( cat_cols = c("...'     ####


  # ONLY cat_cols


  ## Testing 'calculate_max_prefix_nchars_( cat_cols = c("...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- calculate_max_prefix_nchars_(
      cat_cols = c("hej_133", "hej_233"),
      num_cols = NULL
    )
  # Testing class
  expect_equal(
    class(output_19148),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "list")
  # Testing values
  expect_equal(
    output_19148,
    list(max_cat_prefix_chars = 5L))
  # Testing names
  expect_equal(
    names(output_19148),
    "max_cat_prefix_chars",
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    1L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    1L)
  ## Finished testing 'calculate_max_prefix_nchars_( cat_cols = c("...'     ####

  # ONLY num_cols


  ## Testing 'calculate_max_prefix_nchars_( cat_cols = NUL...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- calculate_max_prefix_nchars_(
      cat_cols = NULL,
      num_cols = c("hej_133", "hej_233")
    )
  # Testing class
  expect_equal(
    class(output_19148),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "list")
  # Testing values
  expect_equal(
    output_19148,
    list(max_num_prefix_chars = 5L))
  # Testing names
  expect_equal(
    names(output_19148),
    "max_num_prefix_chars",
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    1L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    1L)
  ## Finished testing 'calculate_max_prefix_nchars_( cat_cols = NUL...'     ####


})

test_that("testing create_group_balance_summaries_()", {
  xpectr::set_test_seed(42)

  df <- data.frame(
    "some_var" = runif(25),
    "some_factor" = factor(sample(1:3, size = 25, replace=TRUE)),
    "some_id" = factor(sample(1:7, size = 25, replace=TRUE)),
    "grp_1" = factor(sample(1:5, size = 25, replace=TRUE)),
    "grp_2" = factor(sample(1:8, size = 25, replace=TRUE)),
    "grp_3" = factor(sample(LETTERS[1:3], size = 25, replace=TRUE)),
    "grp_4" = factor(sample(LETTERS[1:12], size = 25, replace=TRUE))
  )

  summs <- create_group_balance_summaries_(
    data = df,
    group_cols = c("grp_1"),
    cat_cols = c("some_factor"),
    num_cols = c("some_var"),
    id_cols = c("some_id"),
    summarize_size = TRUE,
    max_cat_prefix_chars = 6)


  ## Testing 'summs$empty'                                                  ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(summs$empty),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    summs$empty[[".group_col"]],
    structure(c(1L, 1L, 1L, 1L, 1L), .Label = "grp_1", class = "factor"))
  expect_equal(
    summs$empty[[".group"]],
    structure(1:5, .Label = c("1", "2", "3", "4", "5"), class = "factor"))
  # Testing column names
  expect_equal(
    names(summs$empty),
    c(".group_col", ".group"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(summs$empty),
    c("factor", "factor"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(summs$empty),
    c("integer", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(summs$empty),
    c(5L, 2L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(summs$empty)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'summs$empty'                                         ####


  # Size

  expect_equal(
    summs$size$`# rows`,
    create_size_summary_(df, group_col = "grp_1", name = "# rows")$`# rows`
  )

  ## Testing 'summs$size'                                                   ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(summs$size),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    summs$size[[".group_col"]],
    structure(c(1L, 1L, 1L, 1L, 1L), .Label = "grp_1", class = "factor"))
  expect_equal(
    summs$size[[".group"]],
    structure(1:5, .Label = c("1", "2", "3", "4", "5"), class = "factor"))
  expect_equal(
    summs$size[["# rows"]],
    c(6, 6, 4, 7, 2),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(summs$size),
    c(".group_col", ".group", "# rows"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(summs$size),
    c("factor", "factor", "integer"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(summs$size),
    c("integer", "integer", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(summs$size),
    c(5L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(summs$size)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'summs$size'                                          ####

  # ID

  expect_equal(
    summs$id$`# some_id`,
    create_id_summaries_(df, group_col = "grp_1",
                         id_cols = "some_id",
                         name_prefix = "# ")$`# some_id`
  )


  ## Testing 'summs$id'                                                     ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(summs$id),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    summs$id[[".group_col"]],
    structure(c(1L, 1L, 1L, 1L, 1L), .Label = "grp_1", class = "factor"))
  expect_equal(
    summs$id[[".group"]],
    structure(1:5, .Label = c("1", "2", "3", "4", "5"), class = "factor"))
  expect_equal(
    summs$id[["# some_id"]],
    c(6, 5, 3, 4, 2),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(summs$id),
    c(".group_col", ".group", "# some_id"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(summs$id),
    c("factor", "factor", "integer"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(summs$id),
    c("integer", "integer", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(summs$id),
    c(5L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(summs$id)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'summs$id'                                            ####

  # Numeric

  expect_equal(
    summs$num[, 3:4],
    create_num_summaries_(
      df,
      group_col = "grp_1",
      num_cols = "some_var",
      rename = TRUE
    )[, 2:3]
  )

  ## Testing 'summs$num'                                                    ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(summs$num),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    summs$num[[".group_col"]],
    structure(c(1L, 1L, 1L, 1L, 1L), .Label = "grp_1", class = "factor"))
  expect_equal(
    summs$num[[".group"]],
    structure(1:5, .Label = c("1", "2", "3", "4", "5"), class = "factor"))
  expect_equal(
    summs$num[["mean(some_var)"]],
    c(0.74729, 0.30973, 0.69904, 0.73572, 0.51766),
    tolerance = 1e-4)
  expect_equal(
    summs$num[["sum(some_var)"]],
    c(4.48374, 1.85841, 2.79618, 5.15001, 1.03533),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(summs$num),
    c(".group_col", ".group", "mean(some_var)", "sum(some_var)"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(summs$num),
    c("factor", "factor", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(summs$num),
    c("integer", "integer", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(summs$num),
    5:4)
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(summs$num)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'summs$num'                                           ####

  expect_equal(
    summs$cat[, 3:5],
    create_cat_summaries_(
      df,
      group_col = "grp_1",
      cat_cols = "some_factor",
      max_cat_prefix_chars = 6,
      name_prefix = "# "
    )[, 2:4]
  )

  ## Testing 'summs$cat'                                                    ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(summs$cat),
    "data.frame",
    fixed = TRUE)
  # Testing column values
  expect_equal(
    summs$cat[[".group_col"]],
    structure(c(1L, 1L, 1L, 1L, 1L), .Label = "grp_1", class = "factor"))
  expect_equal(
    summs$cat[[".group"]],
    structure(1:5, .Label = c("1", "2", "3", "4", "5"), class = "factor"))
  expect_equal(
    summs$cat[["# some_f_1"]],
    c(1, 2, 0, 1, 0),
    tolerance = 1e-4)
  expect_equal(
    summs$cat[["# some_f_2"]],
    c(2, 2, 2, 3, 1),
    tolerance = 1e-4)
  expect_equal(
    summs$cat[["# some_f_3"]],
    c(3, 2, 2, 3, 1),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(summs$cat),
    c(".group_col", ".group", "# some_f_1", "# some_f_2", "# some_f_3"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(summs$cat),
    c("factor", "factor", "numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(summs$cat),
    c("integer", "integer", "double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(summs$cat),
    c(5L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(summs$cat)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'summs$cat'                                           ####


  # With two group columns!

  summs <- create_group_balance_summaries_(
    data = df,
    group_cols = c("grp_1", "grp_2"),
    cat_cols = c("some_factor"),
    num_cols = c("some_var"),
    id_cols = c("some_id"),
    summarize_size = TRUE,
    max_cat_prefix_chars = 6)


  ## Testing 'summs$empty'                                                  ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(summs$empty),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    summs$empty[[".group_col"]],
    structure(c(1L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L),
      .Label = c("grp_1", "grp_2"), class = "factor"))
  expect_equal(
    summs$empty[[".group"]],
    structure(c(1L, 2L, 3L, 4L, 5L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L),
      .Label = c("1", "2", "3", "4", "5", "6", "7", "8"), class = "factor"))
  # Testing column names
  expect_equal(
    names(summs$empty),
    c(".group_col", ".group"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(summs$empty),
    c("factor", "factor"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(summs$empty),
    c("integer", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(summs$empty),
    c(13L, 2L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(summs$empty)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'summs$empty'                                         ####


  ## Testing 'summs$size'                                                   ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(summs$size),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    summs$size[[".group_col"]],
    structure(c(1L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L),
      .Label = c("grp_1", "grp_2"), class = "factor"))
  expect_equal(
    summs$size[[".group"]],
    structure(c(1L, 2L, 3L, 4L, 5L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L),
      .Label = c("1", "2", "3", "4", "5", "6", "7", "8"), class = "factor"))
  expect_equal(
    summs$size[["# rows"]],
    c(6, 6, 4, 7, 2, 2, 2, 2, 3, 7, 4, 3, 2),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(summs$size),
    c(".group_col", ".group", "# rows"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(summs$size),
    c("factor", "factor", "integer"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(summs$size),
    c("integer", "integer", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(summs$size),
    c(13L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(summs$size)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'summs$size'                                          ####


  ## Testing 'summs$id'                                                     ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(summs$id),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    summs$id[[".group_col"]],
    structure(c(1L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L),
      .Label = c("grp_1", "grp_2"), class = "factor"))
  expect_equal(
    summs$id[[".group"]],
    structure(c(1L, 2L, 3L, 4L, 5L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L),
      .Label = c("1", "2", "3", "4", "5", "6", "7", "8"), class = "factor"))
  expect_equal(
    summs$id[["# some_id"]],
    c(6, 5, 3, 4, 2, 2, 1, 2, 3, 4, 3, 3, 2),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(summs$id),
    c(".group_col", ".group", "# some_id"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(summs$id),
    c("factor", "factor", "integer"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(summs$id),
    c("integer", "integer", "integer"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(summs$id),
    c(13L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(summs$id)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'summs$id'                                            ####


  ## Testing 'summs$num'                                                    ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(summs$num),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    summs$num[[".group_col"]],
    structure(c(1L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L),
      .Label = c("grp_1", "grp_2"), class = "factor"))
  expect_equal(
    summs$num[[".group"]],
    structure(c(1L, 2L, 3L, 4L, 5L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L),
      .Label = c("1", "2", "3", "4", "5", "6", "7", "8"), class = "factor"))
  expect_equal(
    summs$num[["mean(some_var)"]],
    c(0.74729, 0.30973, 0.69904, 0.73572, 0.51766, 0.84165, 0.61161,
      0.51076, 0.4082, 0.70394, 0.46712, 0.73804, 0.58042),
    tolerance = 1e-4)
  expect_equal(
    summs$num[["sum(some_var)"]],
    c(4.48374, 1.85841, 2.79618, 5.15001, 1.03533, 1.68329, 1.22321,
      1.02152, 1.22459, 4.9276, 1.8685, 2.21412, 1.16084),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(summs$num),
    c(".group_col", ".group", "mean(some_var)", "sum(some_var)"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(summs$num),
    c("factor", "factor", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(summs$num),
    c("integer", "integer", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(summs$num),
    c(13L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(summs$num)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'summs$num'                                           ####


  ## Testing 'summs$cat'                                                    ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(summs$cat),
    "data.frame",
    fixed = TRUE)
  # Testing column values
  expect_equal(
    summs$cat[[".group_col"]],
    structure(c(1L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L),
      .Label = c("grp_1", "grp_2"), class = "factor"))
  expect_equal(
    summs$cat[[".group"]],
    structure(c(1L, 2L, 3L, 4L, 5L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L),
      .Label = c("1", "2", "3", "4", "5", "6", "7", "8"), class = "factor"))
  expect_equal(
    summs$cat[["# some_f_1"]],
    c(1, 2, 0, 1, 0, 1, 0, 1, 0, 0, 0, 2, 0),
    tolerance = 1e-4)
  expect_equal(
    summs$cat[["# some_f_2"]],
    c(2, 2, 2, 3, 1, 1, 1, 0, 1, 3, 3, 1, 0),
    tolerance = 1e-4)
  expect_equal(
    summs$cat[["# some_f_3"]],
    c(3, 2, 2, 3, 1, 0, 1, 1, 2, 4, 1, 0, 2),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(summs$cat),
    c(".group_col", ".group", "# some_f_1", "# some_f_2", "# some_f_3"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(summs$cat),
    c("factor", "factor", "numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(summs$cat),
    c("integer", "integer", "double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(summs$cat),
    c(13L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(summs$cat)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'summs$cat'                                           ####


})

test_that("testing measure_summary_numerics_() and join_group_summaries_()", {
  xpectr::set_test_seed(42)

  df <- data.frame(
    "some_var" = runif(25),
    "some_factor" = factor(sample(1:3, size = 25, replace=TRUE)),
    "some_id" = factor(sample(1:7, size = 25, replace=TRUE)),
    "grp_1" = factor(sample(1:5, size = 25, replace=TRUE)),
    "grp_2" = factor(sample(1:8, size = 25, replace=TRUE)),
    "grp_3" = factor(sample(LETTERS[1:3], size = 25, replace=TRUE)),
    "grp_4" = factor(sample(LETTERS[1:12], size = 25, replace=TRUE))
  )

  summs <- create_group_balance_summaries_(
    data = df,
    group_cols = c("grp_1", "grp_2"),
    cat_cols = c("some_factor"),
    num_cols = c("some_var"),
    id_cols = c("some_id"),
    summarize_size = TRUE,
    max_cat_prefix_chars = 6)

  group_summary <- join_group_summaries_(
    group_summaries = summs,
    cat_cols = "some_factor",
    num_cols = "some_var",
    id_cols = "some_id",
    summarize_size = TRUE
  )

  # Check they were correctly joined

  man_group_summary <-
    purrr::reduce(summs, dplyr::left_join, by = c(".group_col", ".group"))

  expect_identical(
    group_summary,
    man_group_summary
  )


  ## Testing 'group_summary'                                                ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(group_summary),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    group_summary[[".group_col"]],
    structure(c(1L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L),
      .Label = c("grp_1", "grp_2"), class = "factor"))
  expect_equal(
    group_summary[[".group"]],
    structure(c(1L, 2L, 3L, 4L, 5L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L),
      .Label = c("1", "2", "3", "4", "5", "6", "7", "8"), class = "factor"))
  expect_equal(
    group_summary[["# rows"]],
    c(6, 6, 4, 7, 2, 2, 2, 2, 3, 7, 4, 3, 2),
    tolerance = 1e-4)
  expect_equal(
    group_summary[["# some_id"]],
    c(6, 5, 3, 4, 2, 2, 1, 2, 3, 4, 3, 3, 2),
    tolerance = 1e-4)
  expect_equal(
    group_summary[["mean(some_var)"]],
    c(0.74729, 0.30973, 0.69904, 0.73572, 0.51766, 0.84165, 0.61161,
      0.51076, 0.4082, 0.70394, 0.46712, 0.73804, 0.58042),
    tolerance = 1e-4)
  expect_equal(
    group_summary[["sum(some_var)"]],
    c(4.48374, 1.85841, 2.79618, 5.15001, 1.03533, 1.68329, 1.22321,
      1.02152, 1.22459, 4.9276, 1.8685, 2.21412, 1.16084),
    tolerance = 1e-4)
  expect_equal(
    group_summary[["# some_f_1"]],
    c(1, 2, 0, 1, 0, 1, 0, 1, 0, 0, 0, 2, 0),
    tolerance = 1e-4)
  expect_equal(
    group_summary[["# some_f_2"]],
    c(2, 2, 2, 3, 1, 1, 1, 0, 1, 3, 3, 1, 0),
    tolerance = 1e-4)
  expect_equal(
    group_summary[["# some_f_3"]],
    c(3, 2, 2, 3, 1, 0, 1, 1, 2, 4, 1, 0, 2),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(group_summary),
    c(".group_col", ".group", "# rows", "# some_id", "mean(some_var)",
      "sum(some_var)", "# some_f_1", "# some_f_2", "# some_f_3"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(group_summary),
    c("factor", "factor", "integer", "integer", "numeric", "numeric",
      "numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(group_summary),
    c("integer", "integer", "integer", "integer", "double", "double",
      "double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(group_summary),
    c(13L, 9L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(group_summary)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'group_summary'                                       ####


  measured_summ <- measure_summary_numerics_(
    data = group_summary,
    num_cols = "some_var",
    cat_level_cols = list("some_factor" = c("# some_f_1", "# some_f_2", "# some_f_3")),
    id_cols = "some_id",
    summarize_size = TRUE,
    rank_weights = NULL,
    cat_levels_rank_weights = NULL,
    logged_counts = FALSE,
    max_cat_prefix_chars = 6,
    max_num_prefix_chars = 6
  )

  man_measured_summ <- split(group_summary, f = group_summary[[".group_col"]]) %>%
    purrr::map_df(.f = ~{
      purrr::map2_df(
        list(mean, median, sd, IQR, min, max),
        list("mean", "median", "SD",
             "IQR", "min", "max"),
        .f = function(fn, nm){
          .x %>%
            dplyr::group_by(.group_col) %>%
            dplyr::summarise(
              dplyr::across(where(is.numeric), fn)
            ) %>%
            dplyr::mutate(measure = nm)
        }
      )
    }) %>%
    position_first(col = "measure") %>%
    position_first(col = ".group_col")

  # Check without the SD rank columns
  expect_identical(
    measured_summ[, 1:9],
    man_measured_summ
  )

  # Add SD ranks
  man_measured_summ <- man_measured_summ %>%
    dplyr::left_join(
      man_measured_summ %>%
        dplyr::filter(measure == "SD") %>%
        mean_rank_numeric_cols_(cols = c("# some_f_1", "# some_f_2", "# some_f_3"), col_name = "some_f_SD_rank") %>%
        mean_rank_numeric_cols_(cols = c("mean(some_var)", "sum(some_var)"), col_name = "some_v_SD_rank") %>%
        mean_rank_numeric_cols_(cols = c("# rows", "# some_id", "some_f_SD_rank", "some_v_SD_rank"), col_name = "SD_rank",
                                already_rank_cols = "some_f_SD_rank") %>%
        dplyr::select(.group_col, dplyr::ends_with("SD_rank")),
      by = ".group_col"
    )

  # Test SD ranks
  expect_equal(
    measured_summ[, c(1:2, 10:12)],
    man_measured_summ[, c(1:2, 10:12)]
  )

  ## Testing 'measured_summ'                                                ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(measured_summ),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    measured_summ[[".group_col"]],
    structure(c(1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L),
              .Label = c("grp_1", "grp_2"), class = "factor"))
  expect_equal(
    measured_summ[["measure"]],
    c("mean", "median", "SD", "IQR", "min", "max", "mean", "median",
      "SD", "IQR", "min", "max"),
    fixed = TRUE)
  expect_equal(
    measured_summ[["# rows"]],
    c(5, 6, 2, 2, 2, 7, 3.125, 2.5, 1.72689, 1.25, 2, 7),
    tolerance = 1e-4)
  expect_equal(
    measured_summ[["# some_id"]],
    c(4, 4, 1.58114, 2, 2, 6, 2.5, 2.5, 0.92582, 1, 1, 4),
    tolerance = 1e-4)
  expect_equal(
    measured_summ[["mean(some_var)"]],
    c(0.60189, 0.69904, 0.18771, 0.21805, 0.30973, 0.74729, 0.60772,
      0.59601, 0.14673, 0.21262, 0.4082, 0.84165),
    tolerance = 1e-4)
  expect_equal(
    measured_summ[["sum(some_var)"]],
    c(3.06473, 2.79618, 1.73261, 2.62533, 1.03533, 5.15001, 1.91546,
      1.45394, 1.28415, 0.74728, 1.02152, 4.9276),
    tolerance = 1e-4)
  expect_equal(
    measured_summ[["# some_f_1"]],
    c(0.8, 1, 0.83666, 1, 0, 2, 0.5, 0, 0.75593, 1, 0, 2),
    tolerance = 1e-4)
  expect_equal(
    measured_summ[["# some_f_2"]],
    c(2, 2, 0.70711, 0, 1, 3, 1.25, 1, 1.16496, 0.75, 0, 3),
    tolerance = 1e-4)
  expect_equal(
    measured_summ[["# some_f_3"]],
    c(2.2, 2, 0.83666, 1, 1, 3, 1.375, 1, 1.30247, 1.25, 0, 4),
    tolerance = 1e-4)
  expect_equal(
    measured_summ[["some_f_SD_rank"]],
    c(1.33333, 1.33333, 1.33333, 1.33333, 1.33333, 1.33333, 1.66667,
      1.66667, 1.66667, 1.66667, 1.66667, 1.66667),
    tolerance = 1e-4)
  expect_equal(
    measured_summ[["some_v_SD_rank"]],
    c(2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1),
    tolerance = 1e-4)
  expect_equal(
    measured_summ[["SD_rank"]],
    c(1.83333, 1.83333, 1.83333, 1.83333, 1.83333, 1.83333, 1.16667,
      1.16667, 1.16667, 1.16667, 1.16667, 1.16667),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(measured_summ),
    c(".group_col", "measure", "# rows", "# some_id", "mean(some_var)",
      "sum(some_var)", "# some_f_1", "# some_f_2", "# some_f_3", "some_f_SD_rank",
      "some_v_SD_rank", "SD_rank"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(measured_summ),
    c("factor", "character", "numeric", "numeric", "numeric", "numeric",
      "numeric", "numeric", "numeric", "numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(measured_summ),
    c("integer", "character", "double", "double", "double", "double",
      "double", "double", "double", "double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(measured_summ),
    c(12L, 12L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(measured_summ)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'measured_summ'                                       ####


})

test_that("testing ranked_balances()", {
  xpectr::set_test_seed(42)

  # Regression tests

  # The dataset from the example
  df <- data.frame(
    "some_var" = runif(25),
    "some_factor" = factor(sample(1:3, size = 25, replace=TRUE)),
    "some_id" = factor(sample(1:7, size = 25, replace=TRUE)),
    "grp_1" = factor(sample(1:5, size = 25, replace=TRUE)),
    "grp_2" = factor(sample(1:8, size = 25, replace=TRUE)),
    "grp_3" = factor(sample(LETTERS[1:3], size = 25, replace=TRUE)),
    "grp_4" = factor(sample(LETTERS[1:12], size = 25, replace=TRUE))
  )

  summ <- summarize_balances(
    data = df,
    group_cols = paste0('grp_', 1:2),
    num_cols = "some_var",
    cat_cols = "some_factor",
    id_cols = "some_id",
    include_normalized = TRUE
  )


  ## Testing 'ranked_balances(summ)'                                        ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_11364 <- ranked_balances(summ)
  # Testing class
  expect_equal(
    class(output_11364),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_11364[[".group_col"]],
    structure(2:1, .Label = c("grp_1", "grp_2"), class = "factor"))
  expect_equal(
    output_11364[["measure"]],
    c("SD", "SD"),
    fixed = TRUE)
  expect_equal(
    output_11364[["# rows"]],
    c(1.72689, 2),
    tolerance = 1e-4)
  expect_equal(
    output_11364[["# some_id"]],
    c(0.92582, 1.58114),
    tolerance = 1e-4)
  expect_equal(
    output_11364[["mean(some_var)"]],
    c(0.14673, 0.18771),
    tolerance = 1e-4)
  expect_equal(
    output_11364[["sum(some_var)"]],
    c(1.28415, 1.73261),
    tolerance = 1e-4)
  expect_equal(
    output_11364[["# some_1"]],
    c(0.75593, 0.83666),
    tolerance = 1e-4)
  expect_equal(
    output_11364[["# some_2"]],
    c(1.16496, 0.70711),
    tolerance = 1e-4)
  expect_equal(
    output_11364[["# some_3"]],
    c(1.30247, 0.83666),
    tolerance = 1e-4)
  expect_equal(
    output_11364[["some_SD_rank"]],
    c(1.66667, 1.33333),
    tolerance = 1e-4)
  expect_equal(
    output_11364[["some_v_SD_rank"]],
    c(1, 2),
    tolerance = 1e-4)
  expect_equal(
    output_11364[["SD_rank"]],
    c(1.16667, 1.83333),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_11364),
    c(".group_col", "measure", "# rows", "# some_id", "mean(some_var)",
      "sum(some_var)", "# some_1", "# some_2", "# some_3", "some_SD_rank",
      "some_v_SD_rank", "SD_rank"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_11364),
    c("factor", "character", "numeric", "numeric", "numeric", "numeric",
      "numeric", "numeric", "numeric", "numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_11364),
    c("integer", "character", "double", "double", "double", "double",
      "double", "double", "double", "double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_11364),
    c(2L, 12L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_11364)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'ranked_balances(summ)'                               ####


  ## Testing 'ranked_balances(summ, measure = "IQR")'                       ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- ranked_balances(summ, measure = "IQR")
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[[".group_col"]],
    structure(2:1, .Label = c("grp_1", "grp_2"), class = "factor"))
  expect_equal(
    output_19148[["measure"]],
    c("IQR", "IQR"),
    fixed = TRUE)
  expect_equal(
    output_19148[["# rows"]],
    c(1.25, 2),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["# some_id"]],
    c(1, 2),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["mean(some_var)"]],
    c(0.21262, 0.21805),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["sum(some_var)"]],
    c(0.74728, 2.62533),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["# some_1"]],
    c(1, 1),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["# some_2"]],
    c(0.75, 0),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["# some_3"]],
    c(1.25, 1),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["some_SD_rank"]],
    c(1.66667, 1.33333),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["some_v_SD_rank"]],
    c(1, 2),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["SD_rank"]],
    c(1.16667, 1.83333),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19148),
    c(".group_col", "measure", "# rows", "# some_id", "mean(some_var)",
      "sum(some_var)", "# some_1", "# some_2", "# some_3", "some_SD_rank",
      "some_v_SD_rank", "SD_rank"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("factor", "character", "numeric", "numeric", "numeric", "numeric",
      "numeric", "numeric", "numeric", "numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("integer", "character", "double", "double", "double", "double",
      "double", "double", "double", "double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(2L, 12L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'ranked_balances(summ, measure = "IQR")'              ####


  # Unknown metric


  ## Testing 'ranked_balances(summ, measure = "DOG")'                       ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19148 <- xpectr::capture_side_effects(ranked_balances(summ, measure = "DOG"), reset_seed = TRUE)
  expect_match(
    xpectr::strip(side_effects_19148[['error']], lowercase = TRUE),
    xpectr::strip(
      ifelse(is_checkmate_v2_1(),
             "must be a subset of {'mean','median','SD','IQR','min','max'}",
             "must be a subset of set {'mean','median','SD','IQR','min','max'}"
      ), lowercase = TRUE),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)
  ## Finished testing 'ranked_balances(summ, measure = "DOG")'              ####

  # No SD_rank column

  summ <- summarize_balances(
    data = df,
    group_cols = paste0('grp_', 1:2)
  )


  ## Testing 'ranked_balances(summ$Summary %>% dplyr::sele...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11364 <- xpectr::capture_side_effects(ranked_balances(summ$Summary %>% dplyr::select(-"SD_rank")), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11364[['error']]),
    xpectr::strip("1 assertions failed:\n * `summary` must include the `SD_rank` column when containing more than one group column."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11364[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)
  ## Finished testing 'ranked_balances(summ$Summary %>% dplyr::sele...'     ####


})
