% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grmsem.fit.R
\name{grmsem.fit}
\alias{grmsem.fit}
\title{grmsem model fitting function}
\usage{
grmsem.fit(
  ph,
  G,
  A.v.free = NULL,
  E.v.free = NULL,
  A.v.startval = NULL,
  E.v.startval = NULL,
  LogL = FALSE,
  estSE = FALSE,
  cores = 1,
  model = "Cholesky",
  compl.ph = FALSE,
  printest = FALSE,
  cluster = "PSOCK",
  optim = "optim",
  verbose = FALSE
)
}
\arguments{
\item{ph}{phenotype file as R dataframe, even for single vectors (columns: k phenotypes, rows: ni individuals in same order as G). No default.}

\item{G}{GRM matrix as provided by the grm.input or grm.bin.input.R function. Use the same order of individuals as in ph. No default.}

\item{A.v.free}{vector of free parameters for genetic factor loadings (free:1, not-free:0). Default NULL, all parameters are estimated.}

\item{E.v.free}{vector of free parameters for residual factor loadings (free:1, not-free:0). Default NULL, all parameters are estimated.}

\item{A.v.startval}{vector of starting values for genetic factor loadings. Default NULL, all starting values are generated.}

\item{E.v.startval}{vector of starting values for residual factor loadings. Default NULL, all starting values are generated.}

\item{LogL}{estimation of the loglikelihood using optim BFGS (TRUE/FALSE). Default FALSE.}

\item{estSE}{estimation of standard errors by recalculating the Hessian matrix. Default FALSE.}

\item{cores}{number of cores for multi-threaded calculations (numeric). Default 1.}

\item{model}{grmsem model selection. Options: "Cholesky", "IP", "IPC", "DS". Default "Cholesky".}

\item{compl.ph}{listwise complete observations across all phenotypes (all NA are excluded). Default FALSE.}

\item{printest}{print output of the model.fit function including estimates (printest.txt) that can be used as starting values. Default FALSE.}

\item{cluster}{cluster type. Options: "PSOCK", "FORK". Default "PSOCK".}

\item{optim}{optimisation function from stats or optimParallel libraries. Options: "optim", "optimParallel". Default "optim".}

\item{verbose}{additional model fit information: (i) phenotype vector, (ii) n of GRM and corresponding I matrix when data are missing, (iii) Hessian if \code{estSE} \code{TRUE}. Default FALSE.}
}
\value{
\code{grmsem.fit} returns a grmsem.fit list object consisting of:
\item{model.in}{list of input parameters}
\item{formula}{matrix of the model specification}
\item{model.fit}{list output of the maximum likelihood estimation, if \code{LogL} \code{TRUE}}
\item{model.out}{dataframe of fitted grmsem model with estimated parameters and SEs, if \code{estSE} \code{TRUE}}
\item{VCOV}{variance/covariance matrix}
\item{k}{number of phenotypes}
\item{n}{total number of observations across all phenotypes}
\item{n.obs}{number of observations per phenotype}
\item{n.ind}{number of individuals with at least one phenotype}
\item{model}{type of grmsem model}
\item{ph.nms}{vector of phenotype names}

\code{model.in} list of input parameters:
\item{part}{a - genetic, e - residual parameters}
\item{label}{parameter label}
\item{value}{starting values}
\item{freepar}{free parameters}

\code{model.fit} list output of the maximum likelihood estimation:
\item{optimisation}{output via optim()}
\item{estimates}{estimated parameters: factor loadings for `Cholesky`, `IP` and `IPC` models, but variance components for `DS`}
\item{LL}{loglikelihood}
\item{calls}{optim() calls}
\item{convergence}{optim() convergence}
\item{message}{optim() message}

\code{model.out} data.frame of fitted grmsem model:
\item{label}{parameter label}
\item{estimates}{estimated parameters}
\item{gradient}{gradient}
\item{se}{SE}
\item{Z}{Z (Wald)}
\item{p}{p (Wald)}
}
\description{
This function fits a grmsem model.
}
\details{
grmsem models estimate genetic (A) and residual (E) variance/covariance of quantitative traits (AE model), where E in GRM-based methods can capture both, shared and unique residual influences. 
The estimation of parameters and their SEs is performed with the function \code{grmsem.fit}. 
Specifically, the loglikelihood is estimated with \code{stats::optim} and the BFGS (Broyden-Fletcher-Goldfarb-Shannon) approach and the variance/covariance matrix of estimated parameters 
with \code{numDeriv::hessian}. The statistical significance of estimated parameters is assessed using a Wald test, assuming multivariate normality. 

\code{grmsem.fit} allows fitting different models describing the underlying multivariate genetic architecture of quantitative traits, 
as captured by a genetic-relationship-matrix (GRM), using structural equation modelling (SEM) techniques and a maximum likelihood approach. 
The user can fit multiple predefined model structures to the data. A Cholesky decomposition, Independent Pathway, 
and hybrid Independent Pathway/Cholesky models can be fitted by setting the \code{model} option to \code{Cholesky}, \code{IP} or \code{IPC}, respectively. 
In addition, the Cholesky model can be re-parametrised as Direct Symmetric model, 
estimating genetic and residual covariances directly, using the \code{model} option \code{DS}. Each model can be adapted by the user by setting free parameters (\code{A.v.free} and \code{E.v.free} options) and starting values (\code{A.v.startval} and  \code{E.v.startval} 
options). 

Input parameters are returned as \code{model.in} list object. Output from the maximum likelihood estimation is also given as 
list \code{model.fit} and the fitted grmsem model with estimated parameters and SEs is returned as dataframe \code{model.out}. 
The returned \code{grmsem.fit} object can be used to estimate genetic and residual covariance and correlations (\code{grmsem.var} function), bivariate heritabilities (\code{grmsem.biher} function), 
and factorial co-heritabilities and co-environmentalities (\code{grmsem.fcoher} function). All estimated parameters of the fitted grmsem model can also be standardised using the function \code{grmsem.stpar}.

Listwise complete observations can be selected with the option \code{compl.ph}=\code{TRUE}. Otherwise, \code{grmsem.fit} fits, like GREML, all available data to the model 
with the default option \code{compl.ph} \code{FALSE}. Using the option \code{LogL}=\code{FALSE}, the user can check the model input parameters and formula without a 
maximum likelihood estimation. Using the option \code{estSE}=\code{FALSE}, the user can carry out a maximum likelihood estimation without the estimation of SEs for 
estimated parameters that require calculating the Hessian. Note that \code{grmsem.fit} should preferably be run in parallel, by setting the \code{cores} option to the required number of cores.

When \code{grmsem.fit} is called with \code{LogL} \code{TRUE}, the user will see also the iterations of the \code{stats::optim} loglikelihood estimation, which are not included in the exported grmsem.fit list object.
}
\examples{
#Set up a Cholesky model: Model formula and total number of parameters
#ph.small is a trivariate phenotype file for 100 individuals in the same order as G.small
#nrow = 100, ncol = 3
#(runtime should be less than one minute)
\donttest{out <- grmsem.fit(ph.small, G.small, LogL = FALSE, estSE = FALSE)}

#Run a Cholesky model:
\donttest{out <- grmsem.fit(ph.small, G.small, LogL = TRUE, estSE = TRUE)}
}
\keyword{grmsem}
