% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_multsbm.R
\docType{class}
\name{MultSbm}
\alias{MultSbm}
\alias{MultSbmPrior-class}
\alias{MultSbm-class}
\alias{MultSbmPrior}
\title{Multinomial Stochastic Block Model Prior class}
\usage{
MultSbmPrior(beta = 1, type = "guess")

MultSbm(alpha = 1, beta = 1, type = "guess")
}
\arguments{
\item{beta}{Dirichlet prior parameter over Multinomial links}

\item{type}{define the type of networks (either "directed", "undirected" or "guess", default to "guess"), for undirected graphs the adjacency matrix is supposed to be symmetric.}

\item{alpha}{Dirichlet prior parameter over the cluster proportions (default to 1)}
}
\value{
a \code{MultSbmPrior-class} object

a \code{MultSbm-class} object
}
\description{
An S4 class to represent a Multinomial Stochastic Block Model. Such model can be used to cluster multi-layer graph vertex, and model a square adjacency cube \eqn{X} of size NxNxM with the following generative model :
\deqn{ \pi \sim Dirichlet(\alpha)}
\deqn{ Z_i  \sim \mathcal{M}(1,\pi)}
\deqn{ \theta_{kl} \sim Dirichlet(\beta)}
\deqn{ X_{ij.}|Z_{ik}Z_{jl}=1 \sim \mathcal{M}(L_{ij},\theta_{kl})}
With \eqn{L_{ij}=\sum_{m=1}^MX_{ijm}}. These classes mainly store the prior parameters value \eqn{\alpha,\beta} of this generative model.
The \code{MultSbm-class} must be used when fitting a simple MultSbm whereas the \code{MultSbmPrior-class} must be sued when fitting a \code{\link{CombinedModels-class}}.
}
\examples{
MultSbmPrior()
MultSbmPrior(type = "undirected")
MultSbm()
MultSbm(type = "undirected")
}
\seealso{
\code{\link{MultSbmFit-class}}, \code{\link{MultSbmPath-class}}

Other DlvmModels: 
\code{\link{CombinedModels}},
\code{\link{DcLbm}},
\code{\link{DcSbm}},
\code{\link{DiagGmm}},
\code{\link{DlvmPrior-class}},
\code{\link{Gmm}},
\code{\link{Lca}},
\code{\link{MoM}},
\code{\link{MoR}},
\code{\link{Sbm}},
\code{\link{greed}()}
}
\concept{DlvmModels}
