% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparsify_block_banded.R
\name{sparsify_block_banded}
\alias{sparsify_block_banded}
\title{Groupwise Block-Banded Sparsifier}
\usage{
sparsify_block_banded(mat, membership, neighbor.range = 1)
}
\arguments{
\item{mat}{A \eqn{d \times d} precision-like matrix specifying the base
matrix to be masked.}

\item{membership}{An integer vector specifying the group membership.
The length of \code{membership} must be consistent with the dimension \eqn{d}.}

\item{neighbor.range}{An integer (default = 1) specifying the neighbor range,
where groups whose labels differ by at most \code{neighbor.range} are
considered neighbors and kept in the mask.}
}
\value{
An object with S3 class \code{"sparsify_block_banded"} containing
the following components:
\describe{
\item{Omega}{The masked precision matrix.}
\item{Sigma}{The covariance matrix, i.e., the inverse of \code{Omega}.}
\item{sparsity}{Proportion of zero entries in \code{Omega}.}
\item{membership}{An integer vector specifying the group membership.}
}
}
\description{
Make a precision-like matrix block-banded according to group membership,
keeping only entries within specified group neighborhoods.
}
\examples{
library(grasps)

## reproducibility for everything
set.seed(1234)

## precision matrix estimation
X <- matrix(rnorm(200), 10, 20)
membership <- c(rep(1,5), rep(2,5), rep(3,4), rep(4,6))
est <- grasps(X, membership = membership, penalty = "lasso", crit = "BIC")

## default: keep blocks within ±1 of each group
res1 <- sparsify_block_banded(est$hatOmega, membership, neighbor.range = 1)
plot(res1)

## wider band: keep blocks within ±2 of each group
res2 <- sparsify_block_banded(est$hatOmega, membership, neighbor.range = 2)
plot(res2)

## special case: block-diagonal matrix
res3 <- sparsify_block_banded(est$hatOmega, membership, neighbor.range = 0)
plot(res3)
}
