% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_functions.R
\name{rmstable_tree}
\alias{rmstable_tree}
\title{Sampling of a multivariate max-stable distribution on a tree}
\usage{
rmstable_tree(n, model = c("HR", "logistic", "dirichlet")[1], tree, par)
}
\arguments{
\item{n}{Number of simulations.}

\item{model}{The parametric model type; one of:
\itemize{
\item \code{HR} (default),
\item \code{logistic},
\item \code{dirichlet}.
}}

\item{tree}{Graph object from \code{igraph} package.
This object must be a tree, i.e., an
undirected graph that is connected and has no cycles.}

\item{par}{Respective parameter for the given \code{model}, that is,
\itemize{
\item \eGamma, numeric \dxd variogram matrix,
where only the entries corresponding to the edges of the \code{tree} are used,
if \code{model = HR}. Alternatively, can be a vector of
length \code{d-1} containing the entries of the variogram corresponding
to the edges of the given \code{tree}.
\item \eqn{\theta \in (0, 1)}{0 < \theta < 1}, vector of length \code{d-1}
containing the logistic parameters corresponding
to the edges of the given \code{tree}, if \code{model = logistic}.
\item a matrix of size \eqn{(d - 1) \times 2}{(d - 1) x 2}, where the rows
contain the parameter vectors \eqn{\alpha} of size 2 with positive entries
for each of the edges in \code{tree}, if \code{model = dirichlet}.
}}
}
\value{
Numeric \nxd matrix of simulations of the
multivariate max-stable distribution.
}
\description{
Simulates exact samples of a multivariate max-stable distribution that
is an extremal graphical model on a tree as defined in \insertCite{eng2019;textual}{graphicalExtremes}.
}
\details{
The simulation follows a combination of the extremal function algorithm in \insertCite{dom2016;textual}{graphicalExtremes}
and the theory in \insertCite{eng2019;textual}{graphicalExtremes} to sample from a single extremal function.
For details on the parameters of the Huesler-Reiss, logistic
and negative logistic distributions see \insertCite{dom2016;textual}{graphicalExtremes}, and for the Dirichlet
distribution see \insertCite{coles1991modelling;textual}{graphicalExtremes}.
}
\examples{
## A 4-dimensional HR tree model

my_tree <- igraph::graph_from_adjacency_matrix(rbind(
  c(0, 1, 0, 0),
  c(1, 0, 1, 1),
  c(0, 1, 0, 0),
  c(0, 1, 0, 0)
),
mode = "undirected"
)
n <- 10
Gamma_vec <- c(.5, 1.4, .8)
rmstable_tree(n, "HR", tree = my_tree, par = Gamma_vec)

## A 4-dimensional Dirichlet model with asymmetric edge distributions

alpha <- cbind(c(.2, 1, .5), c(1.5, .6, .8))
rmstable_tree(n, model = "dirichlet", tree = my_tree, par = alpha)
}
\references{
\insertAllCited{}
}
\seealso{
Other sampling functions:
\code{\link{rmpareto}()},
\code{\link{rmpareto_tree}()},
\code{\link{rmstable}()}
}
\concept{samplingFunctions}
