% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_transformations.R
\name{chi2Gamma}
\alias{chi2Gamma}
\alias{Gamma2chi}
\title{Transformation between \eChi and \eGamma}
\usage{
chi2Gamma(chi)

Gamma2chi(Gamma)
}
\arguments{
\item{chi}{Numeric vector or matrix with entries between 0 and 1.}

\item{Gamma}{Numeric vector or matrix with non-negative entries.}
}
\value{
Numeric vector or matrix containing the implied \eGamma.

Numeric vector or matrix containing the implied \eChi.
}
\description{
Transforms between the extremal correlation \eChi and the variogram \eGamma.
Only valid for Huesler-Reiss distributions.
Done element-wise, no checks of the entire matrix structure are performed.
}
\details{
The formula for transformation from \eChi to \eGamma is element-wise
\deqn{\Gamma = (2 \Phi^{-1}(1 - 0.5 \chi))^2,}
where \eqn{\Phi^{-1}} is the inverse of the standard normal distribution function.

The formula for transformation from \eGamma to \eChi is element-wise
\deqn{\chi = 2 - 2 \Phi(\sqrt{\Gamma} / 2),}{\chi = 2 - 2 \Phi(sqrt(\Gamma) / 2),}
where \eqn{\Phi} is the standard normal distribution function.
}
\seealso{
Other parameter matrix transformations:
\code{\link{Gamma2Sigma}()},
\code{\link{Gamma2graph}()},
\code{\link{par2Matrix}()}
}
\concept{matrixTransformations}
