% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gf_interface.R
\name{gf_graphframe}
\alias{gf_graphframe}
\title{Create a new GraphFrame}
\usage{
gf_graphframe(vertices = NULL, edges)
}
\arguments{
\item{vertices}{A \code{tbl_spark} representing vertices.}

\item{edges}{A \code{tbl_psark} representing edges.}
}
\description{
Create a new GraphFrame
}
\examples{
\dontrun{
library(sparklyr)
sc <- spark_connect(master = "local", version = "2.3.0")
v_tbl <- sdf_copy_to(
  sc, data.frame(id = 1:3, name = LETTERS[1:3])
)
e_tbl <- sdf_copy_to(
  sc, data.frame(src = c(1, 2, 2), dst = c(2, 1, 3),
                 action = c("love", "hate", "follow"))
)
gf_graphframe(v_tbl, e_tbl)
gf_graphframe(edges = e_tbl)
}
}
