% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/service-openai_streaming.R
\name{stream_chat_completion}
\alias{stream_chat_completion}
\title{Stream Chat Completion}
\usage{
stream_chat_completion(
  messages = NULL,
  element_callback = cat,
  model = "gpt-3.5-turbo",
  openai_api_key = Sys.getenv("OPENAI_API_KEY")
)
}
\arguments{
\item{messages}{A list of messages in the conversation,
including the current user prompt (optional).}

\item{element_callback}{A callback function to handle each element
of the streamed response (optional).}

\item{model}{A character string specifying the model to use for chat completion.
The default model is "gpt-3.5-turbo".}

\item{openai_api_key}{A character string of the OpenAI API key.
By default, it is fetched from the "OPENAI_API_KEY" environment variable.
Please note that the OpenAI API key is sensitive information and should be
treated accordingly.}
}
\value{
The same as \code{curl::curl_fetch_stream}
}
\description{
\code{stream_chat_completion} sends the prepared chat completion request to the
OpenAI API and retrieves the streamed response.
}
