% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cf.R
\name{cf}
\alias{cf}
\alias{cf_const}
\alias{cf_lin}
\alias{cf_sexp}
\alias{cf_matern32}
\alias{cf_matern52}
\alias{cf_nn}
\alias{cf_periodic}
\alias{cf_prod}
\alias{*.cf}
\title{Initialize covariance function}
\usage{
cf_const(magn = 1, prior_magn = prior_logunif())

cf_lin(vars = NULL, magn = 1, prior_magn = prior_logunif(), normalize = FALSE)

cf_sexp(
  vars = NULL,
  lscale = 0.3,
  magn = 1,
  prior_lscale = prior_logunif(),
  prior_magn = prior_logunif(),
  normalize = FALSE
)

cf_matern32(
  vars = NULL,
  lscale = 0.3,
  magn = 1,
  prior_lscale = prior_logunif(),
  prior_magn = prior_logunif(),
  normalize = FALSE
)

cf_matern52(
  vars = NULL,
  lscale = 0.3,
  magn = 1,
  prior_lscale = prior_logunif(),
  prior_magn = prior_logunif(),
  normalize = FALSE
)

cf_nn(
  vars = NULL,
  sigma0 = 1,
  sigma = 3,
  magn = 1,
  prior_sigma0 = prior_half_t(),
  prior_sigma = prior_half_t(),
  prior_magn = prior_logunif(),
  normalize = TRUE
)

cf_periodic(
  vars = NULL,
  period = 1,
  cf_base = cf_sexp(),
  prior_period = prior_logunif()
)

cf_prod(...)

\method{*}{cf}(cf1, cf2)
}
\arguments{
\item{magn}{Initial value for the magnitude hyperparameter (depicts the magnitude of
the variation captured by the given covariance function).}

\item{prior_magn}{Prior for hypeparameter \code{magn}. See \code{\link{priors}}.}

\item{vars}{Indices of the inputs which are taken into account when calculating this
covariance. If the input matrix has named columns, can also be a vector of column names.
Default is all the inputs.}

\item{normalize}{Whether to automatically scale and center the inputs for the given
covariance function. Can be useful for inputs with mean and variance far from 0 and 1, respectively.}

\item{lscale}{Initial value for the length-scale hyperparameter.}

\item{prior_lscale}{Prior for hyperparameter \code{lscale}. See \code{\link{priors}}.}

\item{sigma0}{Prior std for the bias in the neural network covariance function.}

\item{sigma}{Prior std for the weights in the hidden layers of the neural network
covariance function.}

\item{prior_sigma0}{Prior for hyperparameter \code{sigma0}. See \code{\link{priors}}.}

\item{prior_sigma}{Prior for hyperparameter \code{sigma}. See \code{\link{priors}}.}

\item{period}{Period length for the periodic covariance function.}

\item{cf_base}{Base covariance function that is used to model the variability within each period
in periodic covariance function.}

\item{prior_period}{Prior for hyperparameter \code{period}. See \code{\link{priors}}.}

\item{...}{Meaning depends on context. For \code{cf_prod} pass in the covariance functions in the product.}

\item{cf1}{Instance of a covariance function.}

\item{cf2}{Instance of a covariance function.}
}
\value{
The covariance function object.
}
\description{
Functions for initializing the covariance functions which can then be passed
to \code{\link{gp_init}}. See section Details for explanation of what covariance
function is what.
}
\details{
The supported covariance functions are (see Rasmussen and Williams, 2006):
\describe{
 \item{\code{cf_const}}{ Constant covariance function. Can be used to model the intercept. }
 \item{\code{cf_lin}}{ Linear covariance function. Produces linear functions. }
 \item{\code{cf_sexp}}{ Squared exponential (or exponentiated quadratic, or Gaussian) covariance function.}
 \item{\code{cf_matern32}}{ Matern nu=3/2 covariance function. }
 \item{\code{cf_matern52}}{ Matern nu=5/2 covariance function. }
 \item{\code{cf_nn}}{ Neural network covariance function. }
 \item{\code{cf_periodic}}{ Periodic covariance function. The periodicity is achieved by mapping the
 original inputs through sine and cosine functions, and then applying the base kernel in this new space.}
 \item{\code{cf_prod}}{ Product of two or more covariance functions. }
}
}
\section{References}{


Rasmussen, C. E. and Williams, C. K. I. (2006). Gaussian processes for machine learning. MIT Press.
}

\examples{

# Generate some toy data
set.seed(1242)
n <- 50
x <- matrix(rnorm(n * 3), nrow = n)
f <- sin(x[, 1]) + 0.5 * x[, 2]^2 + x[, 3]
y <- f + 0.5 * rnorm(n)
x <- data.frame(x1 = x[, 1], x2 = x[, 2], x3 = x[, 3])

# Basic usage (single covariance function)
cf <- cf_sexp()
lik <- lik_gaussian()
gp <- gp_init(cf, lik)
gp <- gp_optim(gp, x, y)
plot(gp_pred(gp, x)$mean, y)

# More than one covariance function; one for x1 and x2, and another one for x3
cf1 <- cf_sexp(c("x1", "x2"))
cf2 <- cf_lin("x3")
cfs <- list(cf1, cf2)
lik <- lik_gaussian()
gp <- gp_init(cfs, lik)
gp <- gp_optim(gp, x, y, maxiter = 500)
plot(gp_pred(gp, x)$mean, y)
plot(x[, 3], gp_pred(gp, x, cfind = 2)$mean) # plot effect w.r.t x3 only


}
