% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpkg-class.R
\name{geopackage}
\alias{geopackage}
\alias{geopackage.list}
\alias{geopackage.missing}
\alias{geopackage.SQLiteConnection}
\alias{geopackage.geopackage}
\alias{geopackage.character}
\alias{gpkg}
\title{\code{geopackage} Constructors}
\usage{
geopackage(x, ...)

\method{geopackage}{list}(x, dsn = NULL, connect = FALSE, ...)

\method{geopackage}{missing}(x, connect = FALSE, pattern = "Rgpkg", tmpdir = tempdir(), ...)

\method{geopackage}{SQLiteConnection}(x, connect = FALSE, ...)

\method{geopackage}{geopackage}(x, ...)

\method{geopackage}{character}(x, connect = FALSE, ...)

gpkg(x, ...)
}
\arguments{
\item{x}{list of SpatVectorProxy, SpatRaster, data.frame; or a character containing path to a GeoPackage file; or an SQLiteConnection to a GeoPackage. If missing, a temporary file with .gpkg extension is created in \code{tempdir}.}

\item{...}{Additional arguments [not currently used]}

\item{dsn}{Path to GeoPackage File (may not exist)}

\item{connect}{Connect to database and store connection in result? Default: \code{FALSE}}

\item{pattern}{used only when \code{x} is missing (creating temporary file GeoPackage), passed to \code{tempfile()}; default \code{"Rgpkg"}}

\item{tmpdir}{used only when \code{x} is missing (creating temporary file GeoPackage), passed to \code{tempfile()}; default \code{tempdir()}}
}
\value{
A \emph{geopackage} object
}
\description{
\code{geopackage()} (alias \code{gpkg()}) creates an S3 object of class \code{geopackage}.
}
\details{
Several \code{geopackage()} methods are provided:
\itemize{
\item \verb{geopackage(x=<list>)}: creates a new GeoPackage object from a heterogeneous list of inputs
\item \verb{geopackage(x=<missing>)}: creates a new empty GeoPackage file in \code{tmpdir}
\item \verb{geopackage(x=<SQLiteConnection>)}: creates a GeoPackage object from an existing \emph{SQLite} connection
\item \verb{geopackage(x=<character>)}: creates a GeoPackage object from a path to an existing GeoPackage file
}
}
