% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6-grafos-matriz.R
\encoding{UTF-8}
\name{shave_cycle}
\alias{shave_cycle}
\title{Shaving a hairy cycle}
\usage{
shave_cycle(v, eG)
}
\arguments{
\item{v}{Edge vector of the hairy cycle}

\item{eG}{Graph given as edgelist, see \code{\link[igraph:as_edgelist]{igraph::as_edgelist()}}}
}
\value{
Edge vector of the shaven cycle, to be interpreted with
respect to the edgelist eG.
}
\description{
Removing dangling vertices of a cycle obtained by adding a single
edge to a spanning tree.
}
\details{
When generating a fundamental cycle in a graph, addition of a
single edge to a spanning tree gives a "hairy" cycle, that is,
a single cycle with some dangling branches of the tree.  This
routine removes iteratively all leaves from this "hairy" tree
until only a 2-regular, connected cycle remains, which is a
fundamental cycle of the graph with respect the given spanning
tree.
}
\examples{
## It is used as a subroutine in [generate_fundamental_cycles].

}
\seealso{
\link{generate_fundamental_cycles} generates the edge vectors
of a system of fundamental cycles of a graph,
\link{apply_incidence_map} applies the incidence map of a graph to
an edge vector.
}
\author{
Cesar Asensio
}
