% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/streaming.R
\name{StreamSession}
\alias{StreamSession}
\title{Stream Session R6 Class}
\description{
Stream Session R6 Class

Stream Session R6 Class
}
\details{
Manages a persistent streaming session
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{session_id}}{Unique session identifier}

\item{\code{history}}{Query/response history}

\item{\code{active}}{Whether session is active
Initialize session}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-StreamSession-new}{\code{StreamSession$new()}}
\item \href{#method-StreamSession-query}{\code{StreamSession$query()}}
\item \href{#method-StreamSession-get_history}{\code{StreamSession$get_history()}}
\item \href{#method-StreamSession-close}{\code{StreamSession$close()}}
\item \href{#method-StreamSession-clone}{\code{StreamSession$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StreamSession-new"></a>}}
\if{latex}{\out{\hypertarget{method-StreamSession-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StreamSession$new(session_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{session_id}}{Session identifier
Send query in session}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StreamSession-query"></a>}}
\if{latex}{\out{\hypertarget{method-StreamSession-query}{}}}
\subsection{Method \code{query()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StreamSession$query(query, show_output = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query}}{Query to execute}

\item{\code{show_output}}{Show streaming output}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Response text
Get session history
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StreamSession-get_history"></a>}}
\if{latex}{\out{\hypertarget{method-StreamSession-get_history}{}}}
\subsection{Method \code{get_history()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StreamSession$get_history()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Data frame of queries and responses
Close session
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StreamSession-close"></a>}}
\if{latex}{\out{\hypertarget{method-StreamSession-close}{}}}
\subsection{Method \code{close()}}{
Mark session inactive (client-side). This does not remove any
server-side Goose session.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StreamSession$close()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Invisible NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StreamSession-clone"></a>}}
\if{latex}{\out{\hypertarget{method-StreamSession-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StreamSession$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
