% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workspaces.R
\name{gtm_workspaces_get}
\alias{gtm_workspaces_get}
\title{Get workspace metadata}
\usage{
gtm_workspaces_get(account_id, container_id, workspace_id)
}
\arguments{
\item{account_id}{Account Id}

\item{container_id}{Container Id}

\item{workspace_id}{Workspace Id}
}
\description{
This returns a list containing the metadata about a single Workspace
If you want to get the information for all workspaces, use \code{gtm_workspaces_list}
}
\examples{

\dontrun{
accountId <- 1234567
containerId <- 7654321
workspaceId <- 5

workspace <- gtm_workspaces_get(accountId, containerId, workspaceId)

}

}
\seealso{
\url{https://developers.google.com/tag-platform/tag-manager/api/v2/reference/accounts/containers/workspaces/get}

Other workspace functions: 
\code{\link{gtm_workspaces_create}()},
\code{\link{gtm_workspaces_delete}()},
\code{\link{gtm_workspaces_list}()},
\code{\link{gtm_workspaces_preview}()},
\code{\link{gtm_workspaces_resolve}()},
\code{\link{gtm_workspaces_status}()},
\code{\link{gtm_workspaces_submit}()},
\code{\link{gtm_workspaces_sync}()},
\code{\link{gtm_workspaces_update}()}
}
\concept{workspace functions}
