% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jodatimes.r
\name{checkTimeFormat}
\alias{checkTimeFormat}
\alias{timeFormat}
\alias{joda-times}
\title{DSPL time format verification}
\usage{
checkTimeFormat(fmt)
}
\arguments{
\item{fmt}{String representing a time format to be verified.}
}
\value{
Logical. \code{TRUE} if the string passes the test.
}
\description{
Checks if a string fulfills the joda-times class specifications supported by
DSPL language.
}
\details{
Public Data Explorer currently supports daily, monthly and yearly
distributed data. Joda-time, the corresponding time format on which DSPL
times is based, allows declaring time formats using small case "d" (for
days), capitalized "M" (for months) and small case "y" for years. Some
examples: \tabular{ll}{ Format Specification \tab Data Example\cr "yyyy"
\tab 1988\cr "yyyy-MM" \tab 1988-03\cr "yyyy-MMM" \tab 1988-Mar\cr
"dd-MM-yyyy" \tab 02-03-1988 }
}
\examples{

    checkTimeFormat("yyyy-MM") # TRUE
    checkTimeFormat("MMMyyyy") # TRUE
    checkTimeFormat("mmmyyyy") # FALSE

}
\references{
\itemize{ \item Google Public Data Explorer DSPL time
definition:
\url{https://developers.google.com/public-data/docs/canonical/time?hl=es}
\item Google Public Data Explorer Cookbook for time definitions:
\url{https://developers.google.com/public-data/docs/cookbook#time_recipes}
\item Joda Time 2.1 API:
\url{http://joda-time.sourceforge.net/api-release/org/joda/time/format/DateTimeFormat.html}
}
}
\seealso{
See also \code{\link{dspl}}
}
\author{
George G. Vega Yon
}
\keyword{utilities}
