% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-modules-new.R
\name{metricDimensionSelectUI}
\alias{metricDimensionSelectUI}
\alias{metricDimensionSelect}
\title{metricDimensionSelectUI - GA4 Shiny Module}
\usage{
metricDimensionSelectUI(id, label = "Metric", multiple = TRUE, width = NULL)

metricDimensionSelect(
  id,
  field_type = c("metric", "dimension"),
  custom_meta = NULL,
  default = NULL
)
}
\arguments{
\item{id}{The Shiny id}

\item{label}{label}

\item{multiple}{multiple select}

\item{width}{width of select}

\item{field_type}{metric or dimension}

\item{custom_meta}{Pass a meta field table from \code{ga_meta("ga4")} to get custom fields from GA4 (reactive)}

\item{default}{The default selected choice. First element if NULL}
}
\value{
Shiny UI

the selected variable
}
\description{
Create a Google Analytics variable selector

Shiny Module for use with GA4 metric and dimension fields fetched via \code{ga_meta("ga4")}
}
\examples{

\dontrun{

# ui.R
metricDimensionSelect("mets1")
metricDimensionSelect("dims1")

#server.R
metrics <- metricDimensionSelect("mets1", "metric")
dims <- metricDimensionSelect("dims1", "dimension")



# use in app with custom fields
#' ui <- fluidPage(title = "Shiny App",
                 accountPickerUI("auth_menu", inColumns = TRUE),
                 metricDimensionSelectUI("mets1"),
                 metricDimensionSelectUI("dims_custom")
                 )
server <- function(input, output, session){
  token <- gar_shiny_auth(session)
  
  accs <- reactive({
    req(token)
    ga_account_list("ga4")
   })
   
  # no custom data
  metrics <- metricDimensionSelect("mets1")
   
  # module for authentication
  property_id <- accountPicker("auth_menu", ga_table = accs, id_only = TRUE)
  
  meta <- reactive({
      req(property_id())
      ga_meta("data", propertyId = property_id())
  })
 
  
  # custom data
  dims_custom <- metricDimensionSelect("dims_custom", 
                                       type = "dimension", 
                                       custom_meta = meta())
 }
 
 shinyApp(gar_shiny_ui(ui, login_ui = silent_auth), server)
 


}
}
\seealso{
Other Shiny modules: 
\code{\link{accountPickerUI}()},
\code{\link{authDropdown}()},
\code{\link{authDropdownUI}()},
\code{\link{multi_select}()},
\code{\link{multi_selectUI}()}
}
\concept{Shiny modules}
