% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResamplingSchemes.R
\name{resample_param_cens}
\alias{resample_param_cens}
\title{Parametric resampling scheme for a parametric regression model under random
censorship}
\usage{
resample_param_cens(data, model)
}
\arguments{
\item{data}{\code{data.frame()} with columns x, z and delta containing the
original data}

\item{model}{\link{ParamRegrModel} to use for the resampling}
}
\value{
\code{data.frame()} with columns x, z and delta containing the resampled
data
}
\description{
Generate a new, resampled dataset of the same shape as data
following the given model. The covariates X are kept the same. Survival
times Y are drawn according to \code{model$sample_yx()} and censoring times C
according to the KM estimator.
}
\examples{
# Create an example dataset
n <- 10
x <- cbind(runif(n), rbinom(n, 1, 0.5))
model <- NormalGLM$new()
params <- list(beta = c(2, 3), sd = 1)
y <- model$sample_yx(x, params = params)
c <- rnorm(n, mean(y) * 1.2, sd(y) * 0.5)
z <- pmin(y, c)
delta <- as.numeric(y <= c)
data <- dplyr::tibble(x = x, z = z, delta = delta)

# Fit the model to the data
model$fit(data, params_init = params, inplace = TRUE, loglik = loglik_xzd)

# Resample from the model given data
resample_param_cens(data, model)
}
