% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance.R
\name{funDist}
\alias{funDist}
\title{Distance function}
\usage{
funDist(FD1, FD2, metric, p = NULL, lambda = NULL, phi = NULL,
  k_trunc = NULL)
}
\arguments{
\item{FD1}{a functional data object of type \code{funData} for the first curve}

\item{FD2}{a functional data object of type \code{funData} for the second curve}

\item{metric}{the chosen distance to be used: \code{"L2"} for the classical L2-distance, \code{"trunc"} for the truncated Mahalanobis semi-distance, \code{"mahalanobis"} for the generalized Mahalanobis distance.}

\item{p}{a positive numeric value containing the parameter of the regularizing function for the generalized Mahalanobis distance.}

\item{lambda}{a vector containing the eigenvalues in descending order of the functional data from which the curves are extracted.}

\item{phi}{a matrix containing the eigenfunctions of the functional data in its columns from which the curves are extracted.}

\item{k_trunc}{a positive numeric value representing the number of components at which the truncated mahalanobis distance must be truncated}
}
\value{
The function returns a numeric value indicating the distance between the two curves.
}
\description{
This function allows you to compute the distance between two curves with the chosen metric.
}
\examples{
# Define parameters:
n <- 50
P <- 100
K <- 150

# Grid of the functional dataset
t <- seq( 0, 1, length.out = P )

# Define the means and the parameters to use in the simulation
m1 <- t^2 * ( 1 - t )

rho <- rep( 0, K )
theta <- matrix( 0, K, P )
for ( k in 1:K ) {
  rho[k] <- 1 / ( k + 1 )^2
  if ( k\%\%2 == 0 )
    theta[k, ] <- sqrt( 2 ) * sin( k * pi * t )
  else if ( k\%\%2 != 0 && k != 1 )
    theta[k, ] <- sqrt( 2 ) * cos( ( k - 1 ) * pi * t )
  else
    theta[k, ] <- rep( 1, P )
}

# Simulate the functional data
z <- gmfd_simulate( n, m1, rho = rho, theta = theta )

# Extract two rows of the functional data
x <- funData( t, z[1, ] )
y <- funData( t, z[2, ] )

lambda <- eigen(cov(z))$values
phi <- eigen(cov(z))$vectors

d <- funDist( x, y, metric = "mahalanobis", p = 1, lambda = lambda, phi = phi )
}
\references{
Ghiglietti A., Ieva F., Paganoni A. M. (2017). Statistical inference for stochastic processes:
Two-sample hypothesis tests, \emph{Journal of Statistical Planning and Inference}, 180:49-68.

Ghiglietti A., Paganoni A. M. (2017). Exact tests for the means of gaussian stochastic processes.
\emph{Statistics & Probability Letters}, 131:102--107.
}
\keyword{distance}
