% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/5-show-.R, R/5-show-music.R
\name{show}
\alias{show}
\alias{show.Music}
\title{Show \code{Music} Object}
\usage{
show(x, to, musescore)

\method{show}{Music}(x, to = NULL, musescore = NULL)
}
\arguments{
\item{x}{A \code{Music} object.}

\item{to}{Optional. A character vector, which can be \code{"score"},
\code{"audio"}, or both. It specifies the output format. By default, both
are displayed. You can change the default behavior by setting the
\code{gm.show_to} option with \code{options()}.}

\item{musescore}{Optional. A character vector, which represents
the command line options passed to MuseScore. See
\href{https://musescore.org/en/handbook/4/command-line-usage}{MuseScore command line usage} for details.}
}
\value{
An invisible \code{NULL}. A music score or audio file will be
displayed.
}
\description{
Display a \code{Music} object as a music score or audio file.
}
\details{
This function works in
\itemize{
\item RStudio
\item R Markdown files
\item Jupyter Notebooks
\item Shiny applications
\item R.app GUI
}
}
\examples{
if (interactive()) {
  music <- Music() + Meter(4, 4) + Line("C4")
  show(music, musescore = "-r 800 -T 5")
}
}
