% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1-construct-stem.R
\name{Stem}
\alias{Stem}
\title{Create \code{Stem} Object}
\usage{
Stem(direction, i, to = NULL)
}
\arguments{
\item{direction}{A single character, which can be \code{"down"}, \code{"up"},
\code{"double"}, and \code{"none"}. See
\href{https://w3c.github.io/musicxml/musicxml-reference/data-types/stem-value/}{the MusicXML specification}.}

\item{i}{A single positive integer, which represents the position
of the stem in a musical line.}

\item{to}{Optional. A single character or a single positive integer,
which indicates the musical line where to modify the stem.}
}
\value{
A list of class \code{Stem}.
}
\description{
Create a \code{Stem} object to modify the stem of some note.
}
\examples{
# Create a `Stem`
stem <- Stem("none", 1)
stem

# Add a `Stem` to a `Music`
music <- Music() + Meter(4, 4) + Line(c("C4", "D4")) + stem
music

# Generate the music score
if (interactive()) {
  show(music)
}
}
\seealso{
\code{\link[=+.Music]{+.Music()}} for adding a \code{Stem} to a \code{Music} object.
}
