% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example-glycans.R
\name{n_glycan_core}
\alias{n_glycan_core}
\alias{o_glycan_core_1}
\alias{o_glycan_core_2}
\title{Example Glycan Structures}
\usage{
n_glycan_core(linkage = TRUE, mono_type = "concrete")

o_glycan_core_1(linkage = TRUE, mono_type = "concrete")

o_glycan_core_2(linkage = TRUE, mono_type = "concrete")
}
\arguments{
\item{linkage}{A logical indicating whether to include linkages (e.g. "b1-4").
Default is \code{TRUE}.}

\item{mono_type}{A character string specifying the type of monosaccharides.
Can be "generic" (Hex, HexNAc, dHex, NeuAc, etc.)
or "concrete" (Man, Gal, HexNAc, Fuc, etc.). Default is "concrete".}
}
\value{
A glycan structure (igraph) object.
}
\description{
Create example glycan structures for testing and demonstration.
Includes \strong{N-glycan core} and \strong{O-glycan core 1} and \strong{core 2}.
}
\section{N-Glycan Core}{
\strong{N-Glycans} are branched oligosaccharides that are bound, most commonly,
via GlcNAc to an Asn residue of the protein backbone.
A common motif of all N-glycans is the \strong{chitobiose core},
composed of three mannose and two GlcNAc moieties,
which is commonly attached to the protein backbone via GlcNAc.
The mannose residue is branched and connected via a1,3- and a1,6-glycosidic
linkages to the two other mannose building blocks.

\if{html}{\out{<div class="sourceCode">}}\preformatted{    Man
  a1-6 \\   b1-4      b1-4      b1-
        Man -- GlcNAc -- GlcNAc -
  a1-3 /
    Man
}\if{html}{\out{</div>}}
}

\section{O-Glycan Core}{
\strong{O-Glycans} are highly abundant in extracellular proteins.
Generally, O-glycans are extended following four major core structures:
\strong{core 1}, \strong{core 2}, core 3, and core 4.
The first two are by far the most common core structures in O-glycosylation
and are found throughout the body.

\strong{core 1}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{          a1-
    GalNAc -
   / b1-3
Gal
}\if{html}{\out{</div>}}

\strong{core 2}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{GlcNAc
      \\ b1-6 a1-
       GalNAc -
      / b1-3
   Gal
}\if{html}{\out{</div>}}
}

\examples{
print(n_glycan_core(), verbose = TRUE)
print(o_glycan_core_1(), verbose = TRUE)

}
