% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm.deploy-package.r
\docType{package}
\name{glm.deploy}
\alias{glm.deploy}
\alias{glm.deploy-package}
\title{'C' and 'Java' Source Code Generator for Fitted Glm Objects}
\description{
Provides two functions that generate source code implementing the predict function of fitted glm objects. In this version, code can be generated for either 'C' or 'Java'. The idea is to provide a tool for the easy and fast deployment of glm predictive models into production. The source code generated by this package implements two function/methods. One of such functions implements the equivalent to predict(type="response"), while the second implements predict(type="link"). Source code is written to disk as a .c or .java file in the specified path. In the case of c, an .h file is also generated.
}
\details{
All numeric variables used as input to the glm object are treated as doubles, whereas factors variables are treated as strings.\cr \cr
The \code{glm.deploy} package is compatible with the following link functions in the fitted glm object:
\itemize{
  \item identity
  \item probit
  \item cloglog
  \item log
  \item sqrt
  \item inverse
  \item 1/mu²
  \item logit
}
}
\seealso{
Functions:
\itemize{
  \item \code{\link{glm2c}}
  \item \code{\link{glm2java}}
}
URL: \url{https://github.com/oscarcastrolopez/glm.deploy}
}
\author{
\itemize{
  \item Oscar Castro-Lopez \email{castroloj@gmail.com}
  \item Ines Vega-Lopez \email{ifvega@uas.edu.mx}
}
}
