% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gkwreg-methods.R
\name{confint.gkwreg}
\alias{confint.gkwreg}
\title{Confidence Intervals for Generalized Kumaraswamy Regression Parameters}
\usage{
\method{confint}{gkwreg}(object, parm, level = 0.95, ...)
}
\arguments{
\item{object}{An object of class \code{"gkwreg"} from \code{\link{gkwreg}}.}

\item{parm}{A specification of which parameters are to be given confidence
intervals, either a vector of numbers or a vector of names. If missing,
all parameters are considered.}

\item{level}{The confidence level required. Default is 0.95.}

\item{...}{Additional arguments (currently unused).}
}
\value{
A matrix (or vector) with columns giving lower and upper confidence
limits for each parameter. These will be labeled as (1-level)/2 and
1 - (1-level)/2 in percent (by default 2.5 percent and 97.5 percent).
}
\description{
Computes confidence intervals for model parameters in fitted gkwreg objects
using Wald (normal approximation) method based on asymptotic theory.
}
\details{
The confidence intervals are computed using the Wald method based on
asymptotic normality of maximum likelihood estimators:
\deqn{CI = \hat{\theta} \pm z_{\alpha/2} \times SE(\hat{\theta})}
where \eqn{z_{\alpha/2}} is the appropriate normal quantile and
\eqn{SE(\hat{\theta})} is the standard error from the Hessian matrix.

The model must have been fitted with \code{hessian = TRUE} (the default)
in \code{\link{gkw_control}}. If standard errors are not available, an
error is raised.
}
\examples{
\donttest{
data(GasolineYield)
fit <- gkwreg(yield ~ batch + temp, data = GasolineYield, family = "kw")

# 95 percent confidence intervals
confint(fit)

# 90 percent confidence intervals
confint(fit, level = 0.90)

# Specific parameters
confint(fit, parm = "alpha:(Intercept)")
confint(fit, parm = 1:3)
}

}
\seealso{
\code{\link{gkwreg}}, \code{\link{summary.gkwreg}},
\code{\link[stats]{confint}}
}
\author{
Lopes, J. E.
}
