% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_upset.R
\name{scale_x_upset}
\alias{scale_x_upset}
\title{Scale to make UpSet plots}
\usage{
scale_x_upset(
  order_by = c("freq", "degree"),
  n_sets = Inf,
  n_intersections = Inf,
  sets = NULL,
  intersections = NULL,
  reverse = FALSE,
  ytrans = "identity",
  ...,
  position = "bottom"
)
}
\arguments{
\item{order_by}{either "freq" or "degree". Default: "freq"}

\item{n_sets}{maximum number of sets that are displayed. Default: Inf}

\item{n_intersections}{maximum number of intersections that are
displayed. Default: Inf}

\item{sets}{character vector that specifies which sets are displayed}

\item{intersections}{a list of character vectors that specifies which
intersections are displayed}

\item{reverse}{boolean if the order of the intersections is reversed.
Default: FALSE}

\item{ytrans}{transformers for y axis. For more information see
\code{axis_combmatrix()}. Default: "identity"}

\item{...}{additional parameters for \code{ggplot2::discrete_scale()}}

\item{position}{either "top" or "bottom" to specify where the
combination matrix is drawn. Default: "bottom"}
}
\description{
This function takes a list column and turns it into a combination matrix
axis. It internally wraps the call to \code{scale_x_mergelist()} and
\code{axis_combmatrix()} and makes sure that the elements are sorted by
size.
}
\examples{
library(ggplot2)
ggplot(tidy_movies[1:100, ], aes(x=Genres)) +
  geom_bar() +
  scale_x_upset(reverse = TRUE, sets=c("Drama", "Action"))

 ggplot(tidy_movies[1:100, ], aes(x=Genres)) +
   geom_bar() +
   scale_x_upset(n_intersections = 5, ytrans="sqrt")

 ggplot(tidy_movies[1:100, ], aes(x=Genres, y=year)) +
   geom_boxplot() +
   scale_x_upset(intersections = list(c("Drama", "Comedy"), c("Short"), c("Short", "Animation")),
                 sets = c("Drama", "Comedy", "Short", "Animation", "Horror"))
}
