% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atlases.R
\name{tracula}
\alias{tracula}
\title{TRACULA White Matter Tract Atlas}
\usage{
tracula()
}
\value{
A \code{ggseg_atlas} object with components:
\describe{
\item{atlas}{Character. Atlas name ("tracula")}
\item{type}{Character. Atlas type ("tract")}
\item{palette}{Named character vector of colours for each tract}
\item{data}{A \code{ggseg_data_tract} object containing:
\describe{
\item{centerlines}{List of centerline matrices per tract}
\item{sf}{Simple features data frame for 2D rendering}
}
}
}
}
\description{
Returns the TRACULA (TRActs Constrained by UnderLying Anatomy) white matter
bundle atlas in MNI space.
}
\details{
This atlas contains major white matter tracts reconstructed from diffusion
MRI using FreeSurfer's TRACULA training data. It works with both ggseg
(2D slice projections) and ggseg3d (3D tube mesh visualizations).
}
\examples{
tracula()

atlas_regions(tracula())
}
\references{
Yendiki A, Panneck P, Srinivasan P, et al. (2011).
Automated probabilistic reconstruction of white-matter pathways in
health and disease using an atlas of the underlying anatomy.
Frontiers in Neuroinformatics, 5:23.
\doi{10.3389/fninf.2011.00023}
}
\seealso{
\code{\link[=dk]{dk()}} for cortical parcellation,
\code{\link[=aseg]{aseg()}} for subcortical structures,
\code{\link[=ggseg_atlas]{ggseg_atlas()}} for the atlas class constructor

Other ggseg_atlases: 
\code{\link{aseg}()},
\code{\link{dk}()}
}
\concept{ggseg_atlases}
