% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brain-mesh.R
\name{get_brain_mesh}
\alias{get_brain_mesh}
\title{Get brain surface mesh}
\usage{
get_brain_mesh(
  hemisphere = c("lh", "rh"),
  surface = "inflated",
  brain_meshes = NULL
)
}
\arguments{
\item{hemisphere}{\code{"lh"} or \code{"rh"}}

\item{surface}{Surface type (default \code{"inflated"}). Other surfaces require
ggseg3d or a custom \code{brain_meshes} argument.}

\item{brain_meshes}{Optional user-supplied mesh data. Accepts either
\code{list(lh = list(vertices, faces), rh = ...)} or the legacy
\code{list(lh_inflated = list(vertices, faces), ...)} format.}
}
\value{
A list with \code{vertices} (data.frame with x, y, z) and \code{faces}
(data.frame with i, j, k), or NULL if the mesh is not available.
}
\description{
Retrieves a brain surface mesh for the specified hemisphere and surface type.
By default, provides the inflated fsaverage5 surface from internal data.
Other surfaces (pial, white, semi-inflated) require the ggseg3d package.
}
\examples{
mesh <- get_brain_mesh("lh")
head(mesh$vertices)
}
