% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autograd.R
\name{optimizer_adam}
\alias{optimizer_adam}
\title{Create an Adam optimizer}
\usage{
optimizer_adam(params, lr = 0.001, beta1 = 0.9, beta2 = 0.999, eps = 1e-08)
}
\arguments{
\item{params}{Named list of ag_param tensors}

\item{lr}{Learning rate (default 1e-3)}

\item{beta1}{First moment decay (default 0.9)}

\item{beta2}{Second moment decay (default 0.999)}

\item{eps}{Stability constant (default 1e-8)}
}
\value{
An optimizer environment
}
\description{
Create an Adam optimizer
}
\examples{
\donttest{
w <- ag_param(matrix(runif(4), 2, 2))
opt <- optimizer_adam(list(w = w), lr = 1e-3)
}
}
