% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ag_training.R
\name{lr_scheduler_cosine}
\alias{lr_scheduler_cosine}
\title{Cosine-annealing learning rate scheduler}
\usage{
lr_scheduler_cosine(optimizer, T_max, lr_min = 0, restart = FALSE)
}
\arguments{
\item{optimizer}{Optimizer environment.}

\item{T_max}{Number of steps for one cosine cycle.}

\item{lr_min}{Minimum learning rate (default 0).}

\item{restart}{Logical; if \code{TRUE} restart after \code{T_max} steps.}
}
\value{
An \code{lr_scheduler_cosine} environment
}
\description{
Varies the learning rate following a cosine curve from \code{lr_max} down to
\code{lr_min} over \code{T_max} steps.  Restarts (SGDR-style) if
\code{restart = TRUE}.
}
\examples{
\donttest{
w   <- ag_param(matrix(runif(4), 2, 2))
opt <- optimizer_adam(list(w = w), lr = 0.1)
sch <- lr_scheduler_cosine(opt, T_max = 50L)
for (epoch in 1:50) sch$step()
}
}
