% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn_functional.R
\name{ggml_model}
\alias{ggml_model}
\title{Create a Functional Model}
\usage{
ggml_model(inputs, outputs)
}
\arguments{
\item{inputs}{A \code{ggml_tensor_node} or a list of them (model inputs).}

\item{outputs}{A \code{ggml_tensor_node} or a list of them (model outputs).}
}
\value{
A \code{ggml_functional_model} object.
}
\description{
Assembles a \code{ggml_functional_model} from symbolic input and output
nodes produced by \code{ggml_input()} and \code{ggml_layer_*()} calls.
}
\examples{
\donttest{
x   <- ggml_input(shape = 64L)
out <- x |> ggml_layer_dense(10, activation = "softmax")
model <- ggml_model(inputs = x, outputs = out)
}
}
