% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn_layers.R
\name{ggml_layer_dropout}
\alias{ggml_layer_dropout}
\title{Add Dropout Layer}
\usage{
ggml_layer_dropout(
  model,
  rate,
  stochastic = FALSE,
  name = NULL,
  trainable = FALSE
)
}
\arguments{
\item{model}{A \code{ggml_sequential_model} or \code{ggml_tensor_node}.}

\item{rate}{Dropout rate in \code{[0, 1)}.  Fraction of units to "drop".}

\item{stochastic}{Logical.  If \code{TRUE}, use inverted dropout with a
random Bernoulli mask regenerated each epoch (proper regularization).
If \code{FALSE} (default), use deterministic scaling by
\code{(1 - rate)} — cheaper but weaker regularization.}

\item{name}{Optional layer name.}

\item{trainable}{Ignored for dropout (no weights); kept for API consistency.}
}
\value{
The model with the dropout layer appended, or a new tensor node.
}
\description{
Applies dropout regularization. During training, multiplies all activations
by \code{(1 - rate)} (deterministic expected-value scaling).
During inference (\code{training = FALSE}), the layer is an identity (no change).
}
\note{
With \code{stochastic = TRUE} the Bernoulli mask is regenerated once
  per epoch (not per batch), because \code{ggml_opt_fit} processes all
  batches inside a single C call.  This is weaker than per-batch dropout
  but stronger than the deterministic variant.
}
\section{Difference from Keras / inverted dropout}{

Keras implements \emph{inverted dropout}: during training it applies a random
Bernoulli mask and scales surviving activations \emph{up} by
\code{1 / (1 - rate)}, so the expected value of each unit is preserved and
no scaling is needed at inference.

This implementation uses \emph{deterministic scaling} (multiply by
\code{(1 - rate)} at training, identity at inference) — equivalent in
expected value but without stochastic noise.  Consequences:
\itemize{
  \item No random mask → the regularization signal is weaker (no co-adaptation
    breaking).
  \item Activations at training are scaled \emph{down}, not up — the magnitude
    seen by subsequent layers differs from Keras behaviour.
  \item Results are fully deterministic and reproducible without setting a seed.
}
}

\examples{
\donttest{
model <- ggml_model_sequential() |>
  ggml_layer_dense(128, activation = "relu", input_shape = 784L) |>
  ggml_layer_dropout(0.5, stochastic = TRUE) |>
  ggml_layer_dense(10, activation = "softmax")
}
}
